ORCA/M Asm65816 2.1.0

0001 4DAA                       title 'QD Cursor            GS ROM 3.0' 
0002 4DAA              ****************************************************************
0003 4DAA              *                                                              *
0004 4DAA              *                   CURSOR                                     *
0005 4DAA              *                                                              *
0006 4DAA              ****************************************************************
0007 4DAA
0008 4DAA
0009 4DAA              ****************************************************************
0010 4DAA              *                                                              *
0011 4DAA              *                  Copyright (C) 1985-1989                     *
0012 4DAA              *                  All Rights Reserved                         *
0013 4DAA              *                  Apple Computer, Inc.                        *
0014 4DAA              *                                                              *
0015 4DAA              ****************************************************************
0016 4DAA
0017 4DAA
0018 4DAA              **********************************************************************
0019 4DAA              *
0020 4DAA              * Change History
0021 4DAA              *
0022 4DAA              * 11 Nov 88	Steven Glass
0023 4DAA              *
0024 4DAA              * Changed ShieldCursor, UpdateCursor and RefreshCursor to kill 
0025 4DAA              * bug related to shielded obscured cursors.  If an obscured cursor
0026 4DAA              * was shielded, and it moved, it was redrawn anyway (leaving cursor
0027 4DAA              * droppings on the screen).  This happened because ShieldCursor
0028 4DAA              * did not mark the cursor as busy if it was obscured.  Now it
0029 4DAA              * is marked busy no matter what.
0030 4DAA              *
0031 4DAA              * UpdateCursor and RefreshCursor changed to mark the cursor
0032 4DAA              * as shielded if the cursor moved while it was obscured and busy.
0033 4DAA              * Without this change, the cursor could be undrawn even when it
0034 4DAA              * was not visible, leaving cursor droppings on the screen.
0035 4DAA              *
0036 4DAA              * 2/1/89	Mensch
0037 4DAA              *
0038 4DAA              * Modified to shield when drawing to regular and shadowed screen
0039 4DAA              *
0040 4DAA              *
0041 4DAA              *
0042 4DAA              *  3/20/89	Mark Cecys
0043 4DAA              *
0044 4DAA              *  Added "MIDIInputPoll" in time-consumming routines. If assem directive "midi"
0045 4DAA              *  is set to one, then polling will be assembled, otherwise if set to zero,
0046 4DAA              *  no MIDI polling will be added. This is used by MidiTools which patches in
0047 4DAA              *  its local cursor routines to prevent SCC over-run. (QD makefile has midi=0)
0048 4DAA              *  The following PROC's are affected:
0049 4DAA              *
0050 4DAA              *	UserInitCursor
0051 4DAA              *	CalcSaveSize
0052 4DAA              *	iDrawCursor
0053 4DAA              *	iUndrawCursor
0054 4DAA              *
0055 4DAA              *
0056 4DAA              *  24 Apr 89	Steven Glass
0057 4DAA              *
0058 4DAA              *  Fixed bug in UpdateCursor relating to the UseInterrupts Flag
0059 4DAA              *  BRC #48180
0060 4DAA              *
0061 4DAA              **********************************************************************
0062 4DAA
0063 4DAA
0064 4DAA                       include 'all.macros' 
0065 4DAA
0066 4DAA                       include ':QDEquates:qd.data.asm' 
0067 4DAA                       INCLUDE ':QDEquates:core.globals1' 
0068 4DAA                       include '::sys.equs.asm' 
0069 4DAA
0070 4DAA                       title 'Cursor Equates' 
0071 4DAA
0072 4DAA              ScreenStart equ   $2000
0073 4DAA              ScreenHeight equ   200                  ; number of scan lines
0074 4DAA              ScreenWidth equ   160                   ; number of bytes
0075 4DAA
0076 4DAA              MaxWidth equ   32                       ; max number of bytes containing
0077 4DAA              *		; single line of cursor image.
0078 4DAA
0079 4DAA              ;-----------------------------------------------
0080 4DAA              ;
0081 4DAA              ; We start the cursor data on zero page at the end
0082 4DAA              ; of the stuff used by the rest of quickdraw.
0083 4DAA              ;
0084 4DAA              StartofZP equ   CursorSTART
0085 4DAA
0086 4DAA              UseInterrupts equ   StartofZP
0087 4DAA              IntPending equ   UseInterrupts+2
0088 4DAA
0089 4DAA              MouseY   equ   IntPending+2
0090 4DAA              MouseX   equ   MouseY+2
0091 4DAA
0092 4DAA              NextMouseY equ   MouseX+2
0093 4DAA              NextMouseX equ   NextMouseY+2
0094 4DAA
0095 4DAA              CurHeight equ   NextMouseX+2            ; Num scan lines high of cursor
0096 4DAA              CurWidth equ   CurHeight+2              ; Num WORDS wide of cursor
0097 4DAA
0098 4DAA              CursorRect equ   CurWidth+2
0099 4DAA              CursorY1 equ   CursorRect
0100 4DAA              CursorX1 equ   CursorY1+2
0101 4DAA              CursorY2 equ   CursorX1+2
0102 4DAA              CursorX2 equ   CursorY2+2
0103 4DAA
0104 4DAA              CursorMode equ   CursorX2+2
0105 4DAA              CursorRecPtr equ   CursorMode+2
0106 4DAA
0107 4DAA              CursorPtr equ   CursorRecPtr+4
0108 4DAA              MaskPtr  equ   CursorPtr+4
0109 4DAA
0110 4DAA              CursorPtr1 equ   MaskPtr+4
0111 4DAA              MaskPtr1 equ   CursorPtr1+4
0112 4DAA              CursorPtr2 equ   MaskPtr1+4
0113 4DAA              MaskPtr2 equ   CursorPtr2+4
0114 4DAA              CursorPtr3 equ   MaskPtr2+4
0115 4DAA              MaskPtr3 equ   CursorPtr3+4
0116 4DAA              CursorPtr4 equ   MaskPtr3+4
0117 4DAA              MaskPtr4 equ   CursorPtr4+4
0118 4DAA              CursorPtr5 equ   MaskPtr4+4
0119 4DAA              MaskPtr5 equ   CursorPtr5+4
0120 4DAA              CursorPtr6 equ   MaskPtr5+4
0121 4DAA              MaskPtr6 equ   CursorPtr6+4
0122 4DAA              CursorPtr7 equ   MaskPtr6+4
0123 4DAA              MaskPtr7 equ   CursorPtr7+4
0124 4DAA
0125 4DAA              SaveHandle equ   MaskPtr7+4
0126 4DAA
0127 4DAA              SavePtr  equ   SaveHandle+4
0128 4DAA              SaveSize equ   SavePtr+4
0129 4DAA
0130 4DAA              CursorRef equ   SaveSize+2
0131 4DAA              MaskRef  equ   CursorRef+4
0132 4DAA              HotSpot  equ   MaskRef+4
0133 4DAA
0134 4DAA              SaveRef  equ   HotSpot+4
0135 4DAA              ScreenRef equ   SaveRef+4
0136 4DAA
0137 4DAA              CursorLevel equ   ScreenRef+2
0138 4DAA              ObscureFlag equ   CursorLevel+2
0139 4DAA
0140 4DAA              StartWord equ   ObscureFlag+2
0141 4DAA
0142 4DAA              ScreenIndex equ   StartWord+2
0143 4DAA              SaveIndex equ   ScreenIndex+2
0144 4DAA              CurrentY equ   SaveIndex+2
0145 4DAA
0146 4DAA              ThisOut  equ   CurrentY+2
0147 4DAA              LastOut  equ   ThisOut+2
0148 4DAA              SrcRef   equ   LastOut+2
0149 4DAA              DestRef  equ   SrcRef+4
0150 4DAA              ThisWord equ   DestRef+4
0151 4DAA
0152 4DAA              HowManyWords equ   ThisWord+2
0153 4DAA              WordCount equ   HowManyWords+2
0154 4DAA              LineCount equ   WordCount+2
0155 4DAA              HowFarToShift equ   LineCount+2
0156 4DAA
0157 4DAA              CursorFlags equ   HowFarToShift+2
0158 4DAA              TempRect equ   CursorFlags+2
0159 4DAA              SaveRect equ   TempRect+8
0160 4DAA
0161 4DAA              ZZEndofCursor equ   SaveRect+8
0162 4DAA
0163 4DAA              Busy_M   equ   $8000
0164 4DAA              Shielded_M equ   $4000
0165 4DAA              ForceU_M equ   $2000
0166 4DAA
0167 4DAA
0168 4DAA                       title 'Cursor Imports and Entries' 
0169 4DAA              ;-----------------------------------------------
0170 4DAA              ;
0171 4DAA              ;   Imported addresses
0172 4DAA              ;
0173 4DAA              ;-----------------------------------------------
0174 4DAA
0175 4DAA                       IMPORT BusyEC0 
0176 4DAA                       IMPORT BusyEC2 
0177 4DAA                       IMPORT BusyEC4 
0178 4DAA                       IMPORT BusyErr0 
0179 4DAA                       IMPORT BusyErr4 
0180 4DAA                       IMPORT QDStart 
0181 4DAA                       IMPORT SpecialNewHandle 
0182 4DAA                       IMPORT xShiftOut 
0183 4DAA                       IMPORT xShiftStay 
0184 4DAA
0185 4DAA              ;-----------------------------------------------
0186 4DAA              ;
0187 4DAA              ;   Forward addresses and entries
0188 4DAA              ;
0189 4DAA              ;-----------------------------------------------
0190 4DAA
0191 4DAA                       ENTRY CalcSaveSize 
0192 4DAA                       ENTRY ClearSCB 
0193 4DAA                       ENTRY GetItReady 
0194 4DAA                       ENTRY RefreshCursor 
0195 4DAA                       ENTRY ShiftOne 
0196 4DAA                       ENTRY UpdateCursor 
0197 4DAA
0198 4DAA                       title 'CursorData' 
0199 4DAA              CursorDATA PROC EXPORT 
0200 4DAA
0201 4DAA
0202 4DAA
0203 4DAA                       EXPORT Arrow320 
0204 4DAA              Arrow320                                ; 
0205 4DAA 0B 00 04 00           DC W:11,4                      ; 11 scan lines by 4 words
0206 4DAE              *     0 2 4 6 8 A C E
0207 4DAE 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00,$00,$00 ; 1
0208 4DB6 0F 00 00 00           DC B:$0F,$00,$00,$00,$00,$00,$00,$00 ; 2
0209 4DBE 0F F0 00 00           DC B:$0F,$F0,$00,$00,$00,$00,$00,$00 ; 3
0210 4DC6 0F FF 00 00           DC B:$0F,$FF,$00,$00,$00,$00,$00,$00 ; 4
0211 4DCE 0F FF F0 00           DC B:$0F,$FF,$F0,$00,$00,$00,$00,$00 ; 5
0212 4DD6 0F FF FF 00           DC B:$0F,$FF,$FF,$00,$00,$00,$00,$00 ; 6
0213 4DDE 0F FF FF F0           DC B:$0F,$FF,$FF,$F0,$00,$00,$00,$00 ; 7
0214 4DE6 0F FF FF FF           DC B:$0F,$FF,$FF,$FF,$00,$00,$00,$00 ; 8
0215 4DEE 0F F0 FF 00           DC B:$0F,$F0,$FF,$00,$00,$00,$00,$00 ; 9
0216 4DF6 00 00 0F F0           DC B:$00,$00,$0F,$F0,$00,$00,$00,$00 ; 10
0217 4DFE 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00,$00,$00 ; 11
0218 4E06
0219 4E06              *     0 2 4 6 8 A C E
0220 4E06 FF 00 00 00           DC B:$FF,$00,$00,$00,$00,$00,$00,$00 ; 1
0221 4E0E FF F0 00 00           DC B:$FF,$F0,$00,$00,$00,$00,$00,$00 ; 2
0222 4E16 FF FF 00 00           DC B:$FF,$FF,$00,$00,$00,$00,$00,$00 ; 3
0223 4E1E FF FF F0 00           DC B:$FF,$FF,$F0,$00,$00,$00,$00,$00 ; 4
0224 4E26 FF FF FF 00           DC B:$FF,$FF,$FF,$00,$00,$00,$00,$00 ; 5
0225 4E2E FF FF FF F0           DC B:$FF,$FF,$FF,$F0,$00,$00,$00,$00 ; 6
0226 4E36 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$00,$00,$00,$00 ; 7
0227 4E3E FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$F0,$00,$00,$00 ; 8
0228 4E46 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$00,$00,$00,$00 ; 9
0229 4E4E FF F0 FF FF           DC B:$FF,$F0,$FF,$FF,$00,$00,$00,$00 ; 10
0230 4E56 00 00 0F FF           DC B:$00,$00,$0F,$FF,$00,$00,$00,$00 ; 11
0231 4E5E
0232 4E5E
0233 4E5E 01 00 01 00           DC W:1,1                       ; hot spot
0234 4E62
0235 4E62
0236 4E62                       EXPORT Arrow640 
0237 4E62              Arrow640                                ; 
0238 4E62 0B 00 02 00           DC W:11,2                      ; 11 scan lines by 2 words
0239 4E66
0240 4E66              *     0   2   4   6   8   A   C   E
0241 4E66 00 00 00 00           DC B:%00000000,%00000000,%00000000,%00000000 ; 1
0242 4E6A 30 00 00 00           DC B:%00110000,%00000000,%00000000,%00000000 ; 2
0243 4E6E 3C 00 00 00           DC B:%00111100,%00000000,%00000000,%00000000 ; 3
0244 4E72 3F 00 00 00           DC B:%00111111,%00000000,%00000000,%00000000 ; 4
0245 4E76 3F C0 00 00           DC B:%00111111,%11000000,%00000000,%00000000 ; 5
0246 4E7A 3F F0 00 00           DC B:%00111111,%11110000,%00000000,%00000000 ; 6
0247 4E7E 3F FC 00 00           DC B:%00111111,%11111100,%00000000,%00000000 ; 7
0248 4E82 3F FF 00 00           DC B:%00111111,%11111111,%00000000,%00000000 ; 8
0249 4E86 3C F0 00 00           DC B:%00111100,%11110000,%00000000,%00000000 ; 9
0250 4E8A 00 3C 00 00           DC B:%00000000,%00111100,%00000000,%00000000 ; 10
0251 4E8E 00 00 00 00           DC B:%00000000,%00000000,%00000000,%00000000 ; 11
0252 4E92
0253 4E92
0254 4E92              *     0   2   4   6   8   A   C   E
0255 4E92 F0 00 00 00           DC B:%11110000,%00000000,%00000000,%00000000 ; 1
0256 4E96 FC 00 00 00           DC B:%11111100,%00000000,%00000000,%00000000 ; 2
0257 4E9A FF 00 00 00           DC B:%11111111,%00000000,%00000000,%00000000 ; 3
0258 4E9E FF C0 00 00           DC B:%11111111,%11000000,%00000000,%00000000 ; 4
0259 4EA2 FF F0 00 00           DC B:%11111111,%11110000,%00000000,%00000000 ; 5
0260 4EA6 FF FC 00 00           DC B:%11111111,%11111100,%00000000,%00000000 ; 6
0261 4EAA FF FF 00 00           DC B:%11111111,%11111111,%00000000,%00000000 ; 7
0262 4EAE FF FF C0 00           DC B:%11111111,%11111111,%11000000,%00000000 ; 8
0263 4EB2 FF FF C0 00           DC B:%11111111,%11111111,%11000000,%00000000 ; 9
0264 4EB6 FC FF 00 00           DC B:%11111100,%11111111,%00000000,%00000000 ; 10
0265 4EBA 00 FF 00 00           DC B:%00000000,%11111111,%00000000,%00000000 ; 11
0266 4EBE
0267 4EBE 01 00 01 00           DC W:1,1                       ; hot spot
0268 4EC2
0269 4EC2
0270 4EC2
0271 4EC2
0272 4EC2                       ENDP 
0273 4EC2
0274 4EC2                       title 'InitCursor' 
0275 4EC2              ****************************************************************
0276 4EC2              *
0277 4EC2              * InitCursor
0278 4EC2              *
0279 4EC2              * This is not an entry point!  This is the routine called
0280 4EC2              * at quickdraw startup time.
0281 4EC2              *
0282 4EC2              ****************************************************************
0283 4EC2              InitCursor PROC EXPORT 
0284 4EC2
0285 4EC2 7B                    tdc                            ; get direct reg in a
0286 4EC3 AA                    tax                            ; and in x
0287 4EC4
0288 4EC4 0B                    phd                            ; initialize some stuff
0289 4EC5 18                    clc   
0290 4EC6 69 00 01              adc   #$100
0291 4EC9 5B                    tcd   
0292 4ECA
0293 4ECA BF 0A 00 00           lda   >UserID,x
0294 4ECE AA                    tax   
0295 4ECF A9 00 04              lda   #$400
0296 4ED2 A0 00 80              ldy   #$8000
0297 4ED5 20 3B 13              jsr   SpecialNewHandle
0298 4ED8 90 03                 bcc   GotHandle
0299 4EDA 4C 3C 4F              jmp   ErrorOut
0300 4EDD
0301 4EDD
0302 4EDD              GotHandle                               ; ; dereference the locked handle
0303 4EDD 86 B0                 stx   SaveHandle
0304 4EDF 84 B2                 sty   SaveHandle+2
0305 4EE1 A0 02 00              ldy   #2
0306 4EE4 B7 B0                 lda   [SaveHandle],y
0307 4EE6 85 B6                 sta   SavePtr+2
0308 4EE8 A7 B0                 lda   [SaveHandle]
0309 4EEA 85 B4                 sta   SavePtr
0310 4EEC
0311 4EEC 20 3E 4F              jsr   GetItReady
0312 4EEF B0 4B                 bcs   ErrorOut
0313 4EF1
0314 4EF1 48                    pha                            ; save the old value of the Scan
0315 4EF2 48                    pha                            ; line interrupt vector
0316 4EF3 F4 0A 00              PushWord #ScanIntRefNum 
0317 4EF6 A2 03 11 22           _GetVector 
0318 4EFD
0319 4EFD 68                    pla   
0320 4EFE 8F FC 1F E0           sta   >OldScanInt
0321 4F02 68                    pla   
0322 4F03 8F FE 1F E0           sta   >OldScanInt+2
0323 4F07
0324 4F07
0325 4F07 F4 18 00              PushWord #CurUpdateRefNum      ; install pointer to update
0326 4F0A F4 FE 00 F4           PushLong #UpdateCursor         ; cursor routine
0327 4F10 A2 03 10 22           _SetVector 
0328 4F17
0329 4F17 F4 0A 00              PushWord #ScanIntRefNum        ; install pointer to
0330 4F1A F4 FE 00 F4           PushLong #RefreshCursor        ; cursor refresh routine
0331 4F20 A2 03 10 22           _SetVector 
0332 4F27
0333 4F27 F4 0C 00              PushWord #EnableScanInts       ; turn on scan line interrupts.
0334 4F2A A2 03 23 22           _IntSource 
0335 4F31
0336 4F31 A9 00 80              lda   #$8000                   ; set zero page flag
0337 4F34 85 52                 sta   UseInterrupts
0338 4F36
0339 4F36 2B                    pld   
0340 4F37
0341 4F37 A9 00 00              lda   #0                       ; signal no error
0342 4F3A 18                    clc   
0343 4F3B
0344 4F3B 6B                    rtl   
0345 4F3C
0346 4F3C 2B           ErrorOut pld   
0347 4F3D 6B                    rtl   
0348 4F3E
0349 4F3E
0350 4F3E                       ENDP 
0351 4F3E
0352 4F3E
0353 4F3E                       title 'GetItReady' 
0354 4F3E              ****************************************************************
0355 4F3E              *
0356 4F3E              * GetItReady
0357 4F3E              *
0358 4F3E              * This routine sets up the cursor mode and calls set cursor.
0359 4F3E              *
0360 4F3E              ****************************************************************
0361 4F3E              GetItReady PROC EXPORT 
0362 4F3E
0363 4F3E
0364 4F3E 7B                    tdc                            ; get the zp adr
0365 4F3F 38                    sec                            ; subtract $100
0366 4F40 E9 00 01              sbc   #$100
0367 4F43 AA                    tax                            ; put in x
0368 4F44 BF 08 00 00           lda   >MasterSCB,x             ; move masterSCB from
0369 4F48 85 6A                 sta   CursorMode               ; QD zp to cursor ZP
0370 4F4A
0371 4F4A 64 CE                 stz   ObscureFlag              ; clear the obscure flag
0372 4F4C A9 FF FF              lda   #$FFFF                   ; and set cursor not visible
0373 4F4F 85 CC                 sta   CursorLevel
0374 4F51
0375 4F51              ;-------------------------------------------------
0376 4F51              ;
0377 4F51              ; Now set up a cursor
0378 4F51 24 69                 bit   CursorMode-1
0379 4F53 30 08                 bmi   Mode640
0380 4F55 F4 FE 00 F4           PushLong #Arrow320 
0381 4F5B 80 06                 bra   CallIt
0382 4F5D
0383 4F5D F4 FE 00 F4  Mode640  PushLong #Arrow640 
0384 4F63
0385 4F63 A2 04 8E 22  CallIt   _SetCursor 
0386 4F6A
0387 4F6A 60                    rts   
0388 4F6B
0389 4F6B
0390 4F6B                       ENDP 
0391 4F6B
0392 4F6B
0393 4F6B                       title 'UserInitCursor' 
0394 4F6B              ****************************************************************
0395 4F6B              *
0396 4F6B              * UserInitCursor
0397 4F6B              *
0398 4F6B              * This is the entry point for the user to restore the standard
0399 4F6B              * cursor for the current MasterSCB.
0400 4F6B              *
0401 4F6B              ****************************************************************
0402 4F6B              UserInitCursor PROC EXPORT 
0403 4F6B
0404 4F6B 20 AA 0F              jsr   QDStart
0405 4F6E 18                    clc   
0406 4F6F 69 00 01              adc   #$100
0407 4F72 5B                    tcd   
0408 4F73
0409 4F73 08                    php   
0410 4F74 78                    sei   
0411 4F75 A2 04 90 22           _HideCursor                    ; always hide
0412 4F7C
0413 4F7C 20 3E 4F              jsr   GetItReady               ; reset everything
0414 4F7F B0 0B                 bcs   Error
0415 4F81
0416 4F81 A2 04 91 22           _ShowCursor                    ; show it now that all is reset
0417 4F88
0418 4F88
0419 4F88 28           AllDone  plp   
0420 4F89 4C EA FB              jmp   BusyEC0
0421 4F8C
0422 4F8C 28           Error    plp                            ; restore interrupts
0423 4F8D AA                    tax                            ; put error in x
0424 4F8E 4C ED FB              jmp   BusyErr0                 ; get out
0425 4F91
0426 4F91                       ENDP 
0427 4F91
0428 4F91
0429 4F91                       title 'Lock and Unlock SaveHandle' 
0430 4F91              ****************************************************************
0431 4F91              *
0432 4F91              * LockSaveHandle
0433 4F91              *
0434 4F91              * Internal Routine to quickly lock and dereference the save handle.
0435 4F91              * Relies on fact that lock bit is kept in word immediatly after pointer
0436 4F91              * to data.
0437 4F91              *
0438 4F91              ****************************************************************
0439 4F91              LockSaveHandle PROC EXPORT 
0440 4F91 A0 04 00              ldy   #4
0441 4F94 B7 B0                 lda   [SaveHandle],y
0442 4F96 09 00 80              ora   #$8000
0443 4F99 97 B0                 sta   [SaveHandle],y
0444 4F9B
0445 4F9B A7 B0                 lda   [SaveHandle]
0446 4F9D 85 B4                 sta   SavePtr
0447 4F9F A0 02 00              ldy   #2
0448 4FA2 B7 B0                 lda   [SaveHandle],y
0449 4FA4 85 B6                 sta   SavePtr+2
0450 4FA6
0451 4FA6 60                    rts   
0452 4FA7
0453 4FA7                       ENDP 
0454 4FA7
0455 4FA7              ****************************************************************
0456 4FA7              *
0457 4FA7              * UnlockSavehandle
0458 4FA7              *
0459 4FA7              * Internal routine to quickly unlock the save handle
0460 4FA7              * Relies on fact that lock bit is kept in word immediatly
0461 4FA7              * after pointer to data.
0462 4FA7              *
0463 4FA7              ****************************************************************
0464 4FA7              UnlockSaveHandle PROC EXPORT 
0465 4FA7
0466 4FA7 A0 04 00              ldy   #4
0467 4FAA B7 B0                 lda   [SaveHandle],y
0468 4FAC 29 FF 7F              and   #$7FFF
0469 4FAF 97 B0                 sta   [SaveHandle],y
0470 4FB1 60                    rts   
0471 4FB2
0472 4FB2                       ENDP 
0473 4FB2
0474 4FB2                       title 'CursorShutdown' 
0475 4FB2              ****************************************************************
0476 4FB2              *
0477 4FB2              * CursorShutDown
0478 4FB2              *
0479 4FB2              * Frees up the memory used to save the cursor.
0480 4FB2              *
0481 4FB2              ****************************************************************
0482 4FB2              CursorShutDown PROC EXPORT 
0483 4FB2
0484 4FB2 0B                    phd   
0485 4FB3 7B                    tdc   
0486 4FB4 18                    clc   
0487 4FB5 69 00 01              adc   #$100
0488 4FB8 5B                    tcd   
0489 4FB9
0490 4FB9 F4 0D 00              PushWord #DisableScanInts      ; turn on scan line interrupts.
0491 4FBC A2 03 23 22           _IntSource 
0492 4FC3
0493 4FC3 64 52                 stz   UseInterrupts
0494 4FC5
0495 4FC5 D4 B2                 pei   SaveHandle+2
0496 4FC7 D4 B0                 pei   SaveHandle
0497 4FC9 A2 02 10 22           _DisposeHandle 
0498 4FD0
0499 4FD0 F4 0A 00              PushWord #ScanIntRefNum        ; restore the old value of the scan
0500 4FD3 AF FE 1F E0           lda   >OldScanInt+2            ; line interrupt vector!
0501 4FD7 48                    pha   
0502 4FD8 AF FC 1F E0           lda   >OldScanInt
0503 4FDC 48                    pha   
0504 4FDD A2 03 10 22           _SetVector 
0505 4FE4
0506 4FE4 2B                    pld   
0507 4FE5
0508 4FE5 60                    rts   
0509 4FE6
0510 4FE6                       ENDP 
0511 4FE6
0512 4FE6
0513 4FE6                       title 'ShiftStuff' 
0514 4FE6              ****************************************************************
0515 4FE6              *
0516 4FE6              * ShiftStuff
0517 4FE6              *
0518 4FE6              * This creates the preshifted cursor images used later.
0519 4FE6              *
0520 4FE6              ****************************************************************
0521 4FE6              ShiftStuff PROC EXPORT 
0522 4FE6
0523 4FE6 A2 00 00              ldx   #0
0524 4FE9
0525 4FE9 24 69                 bit   CursorMode-1
0526 4FEB 30 16                 bmi   Mode640
0527 4FED
0528 4FED A9 08 00              lda   #8                       ; 4 * 2
0529 4FF0 85 EC                 sta   HowFarToShift
0530 4FF2
0531 4FF2              Loop320                                 ; 
0532 4FF2
0533 4FF2 20 19 50              jsr   DoPair
0534 4FF5
0535 4FF5 A5 EC                 lda   HowFarToShift
0536 4FF7 18                    clc   
0537 4FF8 69 08 00              adc   #8
0538 4FFB 85 EC                 sta   HowFarToShift
0539 4FFD
0540 4FFD E0 18 00              cpx   #24
0541 5000 90 F0                 bcc   Loop320
0542 5002
0543 5002
0544 5002 60                    rts   
0545 5003
0546 5003 A9 04 00     Mode640  lda   #4                       ; 2 * 2
0547 5006 85 EC                 sta   HowFarToShift
0548 5008
0549 5008              Loop640                                 ; 
0550 5008
0551 5008 20 19 50              jsr   DoPair
0552 500B
0553 500B A5 EC                 lda   HowFarToShift
0554 500D 18                    clc   
0555 500E 69 04 00              adc   #4
0556 5011 85 EC                 sta   HowFarToShift
0557 5013
0558 5013 E0 38 00              cpx   #56
0559 5016 90 F0                 bcc   Loop640
0560 5018
0561 5018
0562 5018 60                    rts   
0563 5019
0564 5019              DoPair                                  ; 
0565 5019
0566 5019 A5 74 85 DC           MoveLong MaskPtr,SrcRef 
0567 5021 B5 7C                 lda   MaskPtr1,x
0568 5023 85 E0                 sta   DestRef
0569 5025 B5 7E                 lda   MaskPtr1+2,x
0570 5027 85 E2                 sta   DestRef+2
0571 5029 DA                    phx   
0572 502A 20 4A 50              jsr   ShiftOne
0573 502D FA                    plx   
0574 502E
0575 502E A5 70 85 DC           MoveLong CursorPtr,SrcRef 
0576 5036 B5 78                 lda   CursorPtr1,x
0577 5038 85 E0                 sta   DestRef
0578 503A B5 7A                 lda   CursorPtr1+2,x
0579 503C 85 E2                 sta   DestRef+2
0580 503E DA                    phx   
0581 503F 20 4A 50              jsr   ShiftOne
0582 5042 FA                    plx   
0583 5043
0584 5043 8A                    txa   
0585 5044 18                    clc   
0586 5045 69 08 00              adc   #8
0587 5048 AA                    tax   
0588 5049
0589 5049 60                    rts   
0590 504A
0591 504A                       ENDP 
0592 504A
0593 504A
0594 504A                       title 'More Shift Stuff' 
0595 504A              ShiftOne PROC EXPORT 
0596 504A
0597 504A A5 5E                 lda   CurHeight
0598 504C 85 EA                 sta   LineCount
0599 504E
0600 504E              BigLoop                                 ; 
0601 504E
0602 504E A5 60                 lda   CurWidth                 ; put num words - 1 in wordcount
0603 5050 3A                    dec   a
0604 5051 85 E8                 sta   WordCount
0605 5053 64 DA                 stz   LastOut
0606 5055
0607 5055
0608 5055 A0 00 00              ldy   #0                       ; start with first word
0609 5058 B7 DC        ShiftLoop lda   [SrcRef],y
0610 505A 85 E4                 sta   ThisWord
0611 505C A6 EC                 ldx   HowFarToShift
0612 505E 22 70 4C FE           jsl   xShiftOut
0613 5062 85 D8                 sta   ThisOut
0614 5064 A5 E4                 lda   ThisWord
0615 5066 A6 EC                 ldx   HowFarToShift
0616 5068 22 E5 4B FE           jsl   xShiftStay
0617 506C 05 DA                 ora   LastOut
0618 506E 97 E0                 sta   [DestRef],y
0619 5070
0620 5070
0621 5070 A5 D8                 lda   ThisOut                  ; move shift outs
0622 5072 85 DA                 sta   LastOut
0623 5074
0624 5074 C8                    iny   
0625 5075 C8                    iny   
0626 5076 C6 E8                 dec   WordCount
0627 5078 10 DE                 bpl   ShiftLoop
0628 507A
0629 507A A5 60                 lda   CurWidth                 ; num words
0630 507C 0A                    asl   a                        ; make into bytes
0631 507D AA                    tax                            ; save copy in x
0632 507E 18                    clc                            ; bump srcref
0633 507F 65 DC                 adc   SrcRef
0634 5081 85 DC                 sta   SrcRef
0635 5083
0636 5083 8A                    txa                            ; use copy in x again
0637 5084 18                    clc                            ; bump destref
0638 5085 65 E0                 adc   DestRef
0639 5087 85 E0                 sta   DestRef
0640 5089
0641 5089 C6 EA                 dec   LineCount
0642 508B 10 C1                 bpl   BigLoop
0643 508D
0644 508D 60                    rts   
0645 508E
0646 508E
0647 508E                       ENDP 
0648 508E
0649 508E
0650 508E                       title 'SetCursor' 
0651 508E              ****************************************************************
0652 508E              *
0653 508E              * SetCursor
0654 508E              *
0655 508E              * Input
0656 508E              *     CursorPtr   long    Points to cursor record
0657 508E              *
0658 508E              *
0659 508E              * The memory pointed to by SavePtr is organized as follows:
0660 508E              *
0661 508E              *      SaveArea	 SaveSize
0662 508E              *      CursorImage1	 SaveSize
0663 508E              *      MaskImage1	 SaveSize
0664 508E              *      CursorImage2	 SaveSize
0665 508E              *      MaskImage2	 SaveSize
0666 508E              *      CursorImage3	 SaveSize
0667 508E              *      MaskImage3	 SaveSize
0668 508E              *      CursorImage4	 SaveSize       needed for 640 mode
0669 508E              *      MaskImage4	 SaveSize
0670 508E              *      CursorImage5	 SaveSize
0671 508E              *      MaskImage5	 SaveSize
0672 508E              *      CursorImage6	 SaveSize
0673 508E              *      MaskImage6	 SaveSize
0674 508E              *      CursorImage7	 SaveSize
0675 508E              *      MaskImage7	 SaveSize
0676 508E              *
0677 508E              * The total memory I need is 7 * SaveSize in 320 mode
0678 508E              * and 15 * SaveSize	in 640 mode.
0679 508E              * 
0680 508E              ****************************************************************
0681 508E              SetCursor PROC EXPORT 
0682 508E
0683 508E              OrigP    equ   1
0684 508E              OrigDirect equ   OrigP+1
0685 508E              RTL1     equ   OrigDirect+2
0686 508E              RTL2     equ   RTL1+3
0687 508E              TheCursorPtr equ   RTL2+3
0688 508E
0689 508E 20 AA 0F              jsr   QDStart
0690 5091 18                    clc   
0691 5092 69 00 01              adc   #$100
0692 5095 5B                    tcd   
0693 5096
0694 5096 08                    php                            ; save PROC EXPORTessor
0695 5097 78                    sei                            ; turn off interrupts to do this
0696 5098
0697 5098 24 CC                 bit   CursorLevel
0698 509A 30 08                 bmi   NotVisible
0699 509C
0700 509C 24 CE                 bit   ObscureFlag
0701 509E 30 04                 bmi   NotVisible
0702 50A0
0703 50A0 22 D0 1F E0           jsl   UnDrawCursor             ; restore under cursor
0704 50A4
0705 50A4              NotVisible                              ; 
0706 50A4
0707 50A4 20 5A 51              jsr   CalcSaveSize
0708 50A7
0709 50A7 48                    pha                            ; put new save size on stack
0710 50A8
0711 50A8              ;----------------------------------------------
0712 50A8              ; Now I need some memory to use for the save
0713 50A8              ; area, and the preshifted cursor images.
0714 50A8              ;
0715 50A8              ; The amount I need is equal to
0716 50A8              ;
0717 50A8              ;      SaveSize (for saving) +
0718 50A8              ;      6 * SaveSize (for 320 mode)  = 7 * SaveSize
0719 50A8              ;
0720 50A8              ;      14 * SaveSize (for 640 mode) = 15 * SaveSize
0721 50A8              ;
0722 50A8 20 A7 4F              jsr   UnlockSaveHandle
0723 50AB
0724 50AB A3 01                 lda   1,s
0725 50AD 0A                    asl   a
0726 50AE 0A                    asl   a
0727 50AF 0A                    asl   a
0728 50B0 24 69                 bit   CursorMode-1
0729 50B2 10 01                 bpl   ThatsEnough
0730 50B4 0A                    asl   a
0731 50B5 38           ThatsEnough sec   
0732 50B6 E3 01                 sbc   1,s
0733 50B8 F4 00 00              pea   0
0734 50BB 48                    pha   
0735 50BC D4 B2                 pei   SaveHandle+2
0736 50BE D4 B0                 pei   SaveHandle
0737 50C0 A2 02 19 22           _SetHandleSize 
0738 50C7
0739 50C7 90 16                 bcc   NoProblem
0740 50C9 48                    pha   
0741 50CA
0742 50CA 20 91 4F              jsr   LockSaveHandle
0743 50CD
0744 50CD 24 CC                 bit   CursorLevel
0745 50CF 30 08                 bmi   StillNotVisible
0746 50D1
0747 50D1 24 CE                 bit   ObscureFlag
0748 50D3 30 04                 bmi   StillNotVisible
0749 50D5
0750 50D5 22 CC 1F E0           jsl   DrawCursor
0751 50D9
0752 50D9 FA           StillNotVisible plx                     ; put error in x
0753 50DA 68                    pla                            ; get new save size off stack
0754 50DB 28                    plp                            ; restore PROC EXPORTessor
0755 50DC 4C 1C FC              jmp   BusyErr4                 ; quit and return error
0756 50DF
0757 50DF
0758 50DF              NoProblem                               ; 
0759 50DF 20 91 4F              jsr   LockSaveHandle
0760 50E2
0761 50E2 FA                    plx                            ; get save size in x so stack is right
0762 50E3 A3 0A                 lda   TheCursorPtr,s           ; get pointer to cursor rec
0763 50E5 85 6C                 sta   CursorRecPtr
0764 50E7 A3 0C                 lda   TheCursorPtr+2,s
0765 50E9 85 6E                 sta   CursorRecPtr+2
0766 50EB
0767 50EB A7 6C                 lda   [CursorRecPtr]           ; I move height and width
0768 50ED 85 5E                 sta   CurHeight                ; to zero page
0769 50EF A0 02 00              ldy   #2
0770 50F2 B7 6C                 lda   [CursorRecPtr],y
0771 50F4 85 60                 sta   CurWidth
0772 50F6
0773 50F6 A5 6C                 lda   CursorRecPtr             ; point to cursor image
0774 50F8 18                    clc   
0775 50F9 69 04 00              adc   #4
0776 50FC 85 70                 sta   CursorPtr
0777 50FE A5 6E                 lda   CursorRecPtr+2
0778 5100 85 72                 sta   CursorPtr+2
0779 5102
0780 5102
0781 5102 8A                    txa                            ; get savesize in a
0782 5103 85 B8                 sta   SaveSize
0783 5105 38                    sec                            ; get rid of extra word per line
0784 5106 E5 5E                 sbc   CurHeight
0785 5108 38                    sec   
0786 5109 E5 5E                 sbc   CurHeight
0787 510B A8                    tay                            ; put copy in Y too
0788 510C 18                    clc   
0789 510D 65 70                 adc   CursorPtr
0790 510F 85 74                 sta   MaskPtr
0791 5111 A5 72                 lda   CursorPtr+2
0792 5113 85 76                 sta   MaskPtr+2
0793 5115
0794 5115 B7 74                 lda   [MaskPtr],y              ; get hot spot
0795 5117 85 C2                 sta   HotSpot
0796 5119 C8                    iny   
0797 511A C8                    iny   
0798 511B B7 74                 lda   [MaskPtr],y
0799 511D 85 C4                 sta   HotSpot+2
0800 511F
0801 511F              ;----------------------------------------------
0802 511F              ;
0803 511F              ; Update the appropriate pointers.
0804 511F              ;
0805 511F A5 B4                 lda   SavePtr                  ; the first pointer is savesize past
0806 5121 18                    clc                            ; saveptr.
0807 5122 65 B8                 adc   SaveSize
0808 5124 85 78                 sta   CursorPtr1
0809 5126 A5 B6                 lda   SavePtr+2
0810 5128 69 00 00              adc   #0
0811 512B 85 7A                 sta   CursorPtr1+2
0812 512D
0813 512D A2 00 00              ldx   #0
0814 5130 B5 78        SetUpLoop lda   CursorPtr1,x
0815 5132 18                    clc   
0816 5133 65 B8                 adc   SaveSize
0817 5135 95 7C                 sta   CursorPtr1+4,x
0818 5137 B5 7A                 lda   CursorPtr1+2,x
0819 5139 69 00 00              adc   #0
0820 513C 95 7E                 sta   CursorPtr1+6,x
0821 513E E8                    inx   
0822 513F E8                    inx   
0823 5140 E8                    inx   
0824 5141 E8                    inx   
0825 5142 E0 34 00              cpx   #13*4                    ; 52, 7 sets of two pointers
0826 5145 90 E9                 bcc   SetUpLoop
0827 5147
0828 5147
0829 5147              ;----------------------------------------------
0830 5147              ;
0831 5147              ; Now I must shift the cursor and mask into
0832 5147              ; the appropriate places.
0833 5147              ;
0834 5147 20 E6 4F              jsr   ShiftStuff
0835 514A
0836 514A
0837 514A
0838 514A              ;----------------------------------------------
0839 514A              ;
0840 514A              ; Now I can show the new cursor
0841 514A              ;
0842 514A 24 CC                 bit   CursorLevel
0843 514C 30 08                 bmi   DoNotShow
0844 514E 24 CE                 bit   ObscureFlag              ; or should a set cursor unobscure it?
0845 5150 30 04                 bmi   DoNotShow
0846 5152 22 CC 1F E0           jsl   DrawCursor
0847 5156 28           DoNotShow plp                           ; restore interrupt status
0848 5157
0849 5157 4C 19 FC              jmp   BusyEC4
0850 515A
0851 515A                       ENDP 
0852 515A
0853 515A                       title 'CalcSaveSize' 
0854 515A              ****************************************************************
0855 515A              ****************************************************************
0856 515A              CalcSaveSize PROC EXPORT 
0857 515A
0858 515A
0859 515A              CurDirect equ   1
0860 515A              ThisRTS  equ   CurDirect+2
0861 515A              OrigP    equ   ThisRTS+2
0862 515A              OrigDirect equ   OrigP+1
0863 515A              RTL1     equ   OrigDirect+2
0864 515A              RTL2     equ   RTL1+3
0865 515A              TheCursorPtr equ   RTL2+3
0866 515A
0867 515A 0B                    phd   
0868 515B 3B                    tsc   
0869 515C 5B                    tcd   
0870 515D
0871 515D F4 00 00 F4           PushLong #0 
0872 5163 A7 0E                 lda   [TheCursorPtr]
0873 5165 48                    pha   
0874 5166 A0 02 00              ldy   #2
0875 5169 B7 0E                 lda   [TheCursorPtr],y
0876 516B 1A                    inc   a                        ; add 1
0877 516C 0A                    asl   a                        ; and double in words
0878 516D 48                    pha   
0879 516E A2 0B 09 22           _Multiply 
0880 5175
0881 5175 68                    pla                            ; result in a
0882 5176 FA                    plx                            ; ignore high word
0883 5177 2B                    pld                            ; restore direct register
0884 5178 60                    rts                            ; all done
0885 5179
0886 5179                       ENDP 
0887 5179
0888 5179                       title 'GetCursorAdr' 
0889 5179              ****************************************************************
0890 5179              *
0891 5179              * GetCursorAdr
0892 5179              *
0893 5179              * Output
0894 5179              *     CursorPtr   long    Points to cursor record
0895 5179              *
0896 5179              ****************************************************************
0897 5179              GetCursorAdr PROC EXPORT 
0898 5179
0899 5179              OrigDirect equ   1
0900 5179              RTL1     equ   OrigDirect+2
0901 5179              RTL2     equ   RTL1+3
0902 5179              TheCursorPtr equ   RTL2+3
0903 5179
0904 5179 20 AA 0F              jsr   QDStart
0905 517C 18                    clc   
0906 517D 69 00 01              adc   #$100
0907 5180 5B                    tcd   
0908 5181
0909 5181 A5 6C                 lda   CursorRecPtr
0910 5183 83 09                 sta   TheCursorPtr,s
0911 5185 A5 6E                 lda   CursorRecPtr+2
0912 5187 83 0B                 sta   TheCursorPtr+2,s
0913 5189
0914 5189 4C EA FB              jmp   BusyEC0
0915 518C
0916 518C                       ENDP 
0917 518C
0918 518C
0919 518C                       title 'ShowCursor' 
0920 518C              ****************************************************************
0921 518C              *
0922 518C              * ShowCursor
0923 518C              *
0924 518C              * Increments the cursor level.
0925 518C              *
0926 518C              *
0927 518C              * Change History
0928 518C              *
0929 518C              * August 21, 1986 SEG   Check for obscure flag is now added.
0930 518C              *	    Obscured cursor is correctly displayed
0931 518C              *	    by showcursor call.
0932 518C              *
0933 518C              * 10 Oct 1986  SEG	   A new problem was found.  When this patch
0934 518C              *	   ran with the cursor obscured and hidden,
0935 518C              *	   the cursor stayed hidden after the show
0936 518C              *	   call.
0937 518C              *
0938 518C              *	   Example:
0939 518C              *	             ObscureCursor
0940 518C              *	             HideCursor
0941 518C              *	             ShowCursor
0942 518C              *
0943 518C              *	   To fix this I do not decrement the
0944 518C              *	   cursor level when the cursor is obscured
0945 518C              *	   if the cursor is already hidden.
0946 518C              *
0947 518C              ****************************************************************
0948 518C              ShowCursor PROC EXPORT 
0949 518C
0950 518C 20 AA 0F              jsr   QDStart
0951 518F 18                    clc   
0952 5190 69 00 01              adc   #$100
0953 5193 5B                    tcd   
0954 5194
0955 5194 08                    php   
0956 5195 78                    sei   
0957 5196
0958 5196 24 CE                 bit   ObscureFlag              ; Check the obscure flag
0959 5198 10 08                 bpl   NoProblem
0960 519A
0961 519A 64 CE                 stz   ObscureFlag              ; clear the flag
0962 519C A5 CC                 lda   CursorLevel              ; no look at the cursor level.
0963 519E 30 02                 bmi   NoProblem                ; if it negative there is nothing more
0964 51A0              *			; to do
0965 51A0 C6 CC                 dec   CursorLevel              ; If zero, dec the cursor level
0966 51A2              *			; so rest of this routine will do
0967 51A2              *			; the right thing.
0968 51A2
0969 51A2 E6 CC        NoProblem inc   CursorLevel
0970 51A4 30 0A                 bmi   AllDone
0971 51A6
0972 51A6 A5 CC                 lda   CursorLevel
0973 51A8 D0 04                 bne   AlreadyVisable
0974 51AA
0975 51AA 22 CC 1F E0           jsl   DrawCursor
0976 51AE
0977 51AE 64 CC        AlreadyVisable stz   CursorLevel
0978 51B0
0979 51B0 28           AllDone  plp   
0980 51B1 4C EA FB              jmp   BusyEC0
0981 51B4
0982 51B4                       ENDP 
0983 51B4
0984 51B4
0985 51B4                       title 'HideCursor' 
0986 51B4              ****************************************************************
0987 51B4              *
0988 51B4              * HideCursor
0989 51B4              *
0990 51B4              * Decrements the cursor level.
0991 51B4              *
0992 51B4              * Change History
0993 51B4              *
0994 51B4              * 10 Oct 1986      SEG       If the cursor was obscured
0995 51B4              *	         this routine undrew it again
0996 51B4              *	         anyway.  This left strange looking
0997 51B4              *	         images on the screen.
0998 51B4              *
0999 51B4              *	         Now we just decrement the level if
1000 51B4              *	         cursor is obsured.
1001 51B4              *
1002 51B4              ****************************************************************
1003 51B4              HideCursor PROC EXPORT 
1004 51B4
1005 51B4 20 AA 0F              jsr   QDStart
1006 51B7 18                    clc   
1007 51B8 69 00 01              adc   #$100
1008 51BB 5B                    tcd   
1009 51BC
1010 51BC 08                    php   
1011 51BD 78                    sei   
1012 51BE
1013 51BE A5 CC                 lda   CursorLevel
1014 51C0 30 08                 bmi   NotVisible
1015 51C2
1016 51C2 24 CE                 bit   ObscureFlag              ; if obscured, then don't undraw!
1017 51C4 30 04                 bmi   NotVisible
1018 51C6
1019 51C6 22 D0 1F E0           jsl   UndrawCursor             ; it was vis and not obscured
1020 51CA
1021 51CA C6 CC        NotVisible dec   CursorLevel            ; always dec level
1022 51CC
1023 51CC 28                    plp   
1024 51CD 4C EA FB              jmp   BusyEC0
1025 51D0
1026 51D0                       ENDP 
1027 51D0
1028 51D0                       title 'ObscureCursor' 
1029 51D0              ****************************************************************
1030 51D0              *
1031 51D0              * ObscureCursor
1032 51D0              *
1033 51D0              * Sets the obscure flag.
1034 51D0              *
1035 51D0              ****************************************************************
1036 51D0              ObscureCursor PROC EXPORT 
1037 51D0
1038 51D0 20 AA 0F              jsr   QDStart
1039 51D3 18                    clc   
1040 51D4 69 00 01              adc   #$100
1041 51D7 5B                    tcd   
1042 51D8
1043 51D8 08                    php   
1044 51D9 78                    sei   
1045 51DA
1046 51DA
1047 51DA A5 CC                 lda   CursorLevel
1048 51DC 30 08                 bmi   NotVisible
1049 51DE
1050 51DE A5 CE                 lda   ObscureFlag
1051 51E0 30 04                 bmi   NotVisible
1052 51E2
1053 51E2 22 D0 1F E0           jsl   UndrawCursor
1054 51E6
1055 51E6 A9 00 80     NotVisible lda   #$8000
1056 51E9 85 CE                 sta   ObscureFlag
1057 51EB
1058 51EB 28                    plp   
1059 51EC 4C EA FB              jmp   BusyEC0
1060 51EF
1061 51EF                       ENDP 
1062 51EF
1063 51EF
1064 51EF                       title 'ShieldCursor' 
1065 51EF              ****************************************************************
1066 51EF              *
1067 51EF              * ShieldCursor
1068 51EF              *
1069 51EF              * This Routine marks the cursor busy and if the min rect and
1070 51EF              * cursor rect intersect, it hides the cursor
1071 51EF              *
1072 51EF              * Change History
1073 51EF              *
1074 51EF              * 21 Aug 86     SEG    Shield cursor made a 4 byte compare
1075 51EF              *      to see if the current port is the
1076 51EF              *      screen to decide if the cursor should
1077 51EF              *      be shielded.  It now does a 3 byte compare
1078 51EF              *      so that system windows will work correctly.
1079 51EF              *
1080 51EF              * 11 Nov 88     SEG    Cursor is always marked busy when this
1081 51EF              *      routine is called.  (Used to only be
1082 51EF              *      marked busy if the cursor was visible--
1083 51EF              *      level positive and not obscured.)
1084 51EF              *
1085 51EF              * 2/24/89	Mensch
1086 51EF              *
1087 51EF              * Changed the direct page setup and moved some of the compares around
1088 51EF              * this should be a 100% speed increase if no shielding is to take place
1089 51EF              *
1090 51EF              ****************************************************************
1091 51EF              iShieldCursor PROC EXPORT 
1092 51EF
1093 51EF A2 00 01              ldx   #$0100                   ; used as an index throughout
1094 51F2              ;-------------------------------------------------
1095 51F2              ;
1096 51F2              ; No matter what, set the cursor busy flag.
1097 51F2              ; Used to only set it if the cursor was visible.
1098 51F2              ;
1099 51F2 A9 00 80              lda   #Busy_M
1100 51F5 95 EE                 sta   <CursorFlags,x
1101 51F7
1102 51F7              ;-------------------------------------------------
1103 51F7              ;
1104 51F7              ; If the cursor is not visible, it cannot be made
1105 51F7              ; visible until after the drawing call is complete
1106 51F7              ; so don't worry.
1107 51F7              ;
1108 51F7 34 CC                 bit   <CursorLevel,x
1109 51F9 30 61                 bmi   NeverMind
1110 51FB
1111 51FB 34 CE                 bit   <ObscureFlag,x
1112 51FD 30 5D                 bmi   NeverMind
1113 51FF
1114 51FF              ;-------------------------------------------------
1115 51FF              ;
1116 51FF              ; Is this drawing going to be to the screen?
1117 51FF              ; If not then don't bother.
1118 51FF              ;
1119 51FF A5 0E                 lda   ImageRef
1120 5201 C9 00 20              cmp   #$2000
1121 5204 D0 56                 bne   NeverMind
1122 5206 A5 0F                 lda   ImageRef+1               ; I only care about 3 bytes in
1123 5208              ;
1124 5208              ; EXP 1/25/89
1125 5208              ; take shadowing into account here!
1126 5208              ;
1127 5208 29 FF 0F              and   #$0FFF                   ; strip off the high bank nibble to accomodate shadowing
1128 520B C9 20 01              cmp   #$0120                   ; the pointer so that system windows
1129 520E D0 4C                 bne   NeverMind                ; will work  21 Aug 86
1130 5210
1131 5210
1132 5210
1133 5210              ;-------------------------------------------------
1134 5210              ;
1135 5210              ; Now decide if the MinRect of the drawing and
1136 5210              ; the cursor rect intersect.
1137 5210              ;
1138 5210 A5 00                 lda   MinRect                  ; get top of min rect
1139 5212 38                    sec                            ; and convert to global
1140 5213 E5 14                 sbc   BoundsRect               ; coordinates
1141 5215
1142 5215 D5 F8                 cmp   <SaveRect,x
1143 5217 10 02                 bpl   MinTopGreater
1144 5219 B5 F8                 lda   <SaveRect,x
1145 521B 95 F0        MinTopGreater sta   <TempRect,x
1146 521D
1147 521D A5 04                 lda   MinRect+4                ; get bot of min rect
1148 521F 38                    sec                            ; and convert to global
1149 5220 E5 14                 sbc   BoundsRect               ; coordinates
1150 5222
1151 5222 D5 FC                 cmp   <SaveRect+4,x
1152 5224 30 02                 bmi   MinBotLess
1153 5226 B5 FC                 lda   <SaveRect+4,x
1154 5228              MinBotLess  
1155 5228 D5 F0                 cmp   <TempRect,x
1156 522A 30 30                 bmi   NeverMind
1157 522C
1158 522C
1159 522C A5 02                 lda   MinRect+2                ; get left of min rect
1160 522E 38                    sec                            ; and convert to global
1161 522F E5 16                 sbc   BoundsRect+2             ; coordinates
1162 5231
1163 5231 D5 FA                 cmp   <SaveRect+2,x
1164 5233 10 02                 bpl   MinLeftGreater
1165 5235 B5 FA                 lda   <SaveRect+2,x
1166 5237 95 F0        MinLeftGreater sta   <TempRect,x
1167 5239
1168 5239
1169 5239 A5 06                 lda   MinRect+6                ; get right of min rect
1170 523B 38                    sec                            ; and convert to global
1171 523C E5 16                 sbc   BoundsRect+2             ; coordinates
1172 523E
1173 523E D5 FE                 cmp   <SaveRect+6,x
1174 5240 30 02                 bmi   MinRightLess
1175 5242 B5 FE                 lda   <SaveRect+6,x
1176 5244              MinRightLess  
1177 5244 D5 F0                 cmp   <TempRect,x
1178 5246 30 14                 bmi   NeverMind
1179 5248
1180 5248              ;-------------------------------------------------
1181 5248              ;
1182 5248              ; Yes they intersect so hide the cursor.
1183 5248              ;
1184 5248 0B                    phd                            ; save the direct reg
1185 5249 7B                    tdc                            ; get it
1186 524A 18                    clc   
1187 524B 69 00 01              adc   #$100                    ; add 100 and put back in d
1188 524E 5B                    tcd   
1189 524F 22 D0 1F E0           jsl   UnDrawCursor             ; undraw it
1190 5253
1191 5253 A9 00 40              lda   #Shielded_M
1192 5256 04 EE                 tsb   CursorFlags
1193 5258 A2 00 01              ldx   #$0100
1194 525B 2B                    pld                            ; restore direct register
1195 525C              NeverMind  
1196 525C 6B                    rtl   
1197 525D
1198 525D                       ENDP 
1199 525D
1200 525D                       title 'UnShieldCursor' 
1201 525D              ****************************************************************
1202 525D              *
1203 525D              * UnShieldCursor
1204 525D              *
1205 525D              * This Routine undoes the work of ShieldCursor above.
1206 525D              *
1207 525D              ****************************************************************
1208 525D              iUnShieldCursor PROC EXPORT 
1209 525D
1210 525D 0B                    phd                            ; save the direct reg
1211 525E 7B                    tdc                            ; get it
1212 525F AA                    tax                            ; put copy in x
1213 5260 18                    clc   
1214 5261 69 00 01              adc   #$100                    ; add 100 and put back in d
1215 5264 5B                    tcd   
1216 5265
1217 5265              ;-------------------------------------------------
1218 5265              ;
1219 5265              ; If the cursor is not shielded, then I don't have
1220 5265              ; to unshield it now.
1221 5265              ;
1222 5265 24 EE                 bit   CursorFlags
1223 5267 70 0B                 bvs   YesShielded
1224 5269
1225 5269 A9 00 20              lda   #ForceU_M
1226 526C 25 EE                 and   CursorFlags
1227 526E F0 08                 beq   NeverMind
1228 5270
1229 5270 22 D0 1F E0           jsl   UnDrawCursor             ; have moved so undraw it and draw again
1230 5274
1231 5274
1232 5274              ;-------------------------------------------------
1233 5274              ;
1234 5274              ; Yes they intersect so hide the cursor.
1235 5274              ;
1236 5274              YesShielded                             ; 
1237 5274 22 CC 1F E0           jsl   DrawCursor               ; draw it
1238 5278
1239 5278
1240 5278 64 EE        NeverMind stz   CursorFlags             ; clear cursor busy
1241 527A 2B                    pld                            ; restore direct register
1242 527B
1243 527B 6B                    rtl   
1244 527C
1245 527C                       ENDP 
1246 527C
1247 527C                       title 'SetMouseLoc' 
1248 527C              ****************************************************************
1249 527C              *
1250 527C              * SetMouseLoc
1251 527C              *
1252 527C              *              MouseX  word
1253 527C              *              MouseY  word
1254 527C              *
1255 527C              * Test call that moves the mouse position.
1256 527C              *
1257 527C              ****************************************************************
1258 527C              SetMouseLoc PROC EXPORT 
1259 527C
1260 527C              OrigDirect equ   1
1261 527C              RTL1     equ   OrigDirect+2
1262 527C              RTL2     equ   RTL1+3
1263 527C              TheMouseY equ   RTL2+3
1264 527C              TheMouseX equ   TheMouseY+2
1265 527C
1266 527C 20 AA 0F              jsr   QDStart
1267 527F 18                    clc   
1268 5280 69 00 01              adc   #$100
1269 5283 5B                    tcd   
1270 5284
1271 5284 24 CC                 bit   CursorLevel
1272 5286 30 0A                 bmi   NotVis1
1273 5288 24 CE                 bit   ObscureFlag
1274 528A 30 06                 bmi   NotVis1
1275 528C
1276 528C              ;-------------------------------------------------
1277 528C              ;
1278 528C              ; Undraw last one
1279 528C              ;
1280 528C DA                    phx   
1281 528D 22 D0 1F E0           jsl   UnDrawCursor
1282 5291 FA                    plx   
1283 5292
1284 5292
1285 5292              ;-------------------------------------------------
1286 5292              ;
1287 5292              ; Set new mouse pos
1288 5292              ;
1289 5292 A3 09        NotVis1  lda   TheMouseY,s
1290 5294 85 56                 sta   MouseY
1291 5296 A3 0B                 lda   TheMouseX,s
1292 5298 85 58                 sta   MouseX
1293 529A
1294 529A 24 CC                 bit   CursorLevel
1295 529C 30 08                 bmi   NotVis2
1296 529E 24 CE                 bit   ObscureFlag
1297 52A0 30 04                 bmi   NotVis2
1298 52A2
1299 52A2              ;-------------------------------------------------
1300 52A2              ;
1301 52A2              ; Draw it in new place
1302 52A2              ;
1303 52A2 22 CC 1F E0           jsl   DrawCursor
1304 52A6
1305 52A6 4C 19 FC     NotVis2  jmp   BusyEC4
1306 52A9
1307 52A9                       ENDP 
1308 52A9
1309 52A9                       title 'SetIntUse' 
1310 52A9              ****************************************************************
1311 52A9              *
1312 52A9              * SetIntUse   (YesOrNo : boolean);
1313 52A9              *
1314 52A9              * If user sends non zero value, I set int use to yes.  If
1315 52A9              * user sends in zero value, I set int use to no.
1316 52A9              *
1317 52A9              ****************************************************************
1318 52A9              SetIntUse PROC EXPORT 
1319 52A9              OrigP    equ   1
1320 52A9              OrigDirect equ   OrigP+1
1321 52A9              RTL1     equ   OrigDirect+2
1322 52A9              RTL2     equ   RTL1+3
1323 52A9              YesOrNo  equ   RTL2+3
1324 52A9
1325 52A9 20 AA 0F              jsr   QDStart
1326 52AC 18                    clc   
1327 52AD 69 00 01              adc   #$100
1328 52B0 5B                    tcd   
1329 52B1
1330 52B1 08                    php                            ; save PROC EXPORTessor
1331 52B2 78                    sei                            ; turn off interrupts to do this
1332 52B3
1333 52B3 A3 0A                 lda   YesOrNo,s
1334 52B5 F0 03                 beq   StoreIt
1335 52B7
1336 52B7 A9 00 80              lda   #$8000
1337 52BA
1338 52BA 85 52        StoreIt  sta   UseInterrupts
1339 52BC
1340 52BC 28                    plp   
1341 52BD 4C 03 FC              jmp   BusyEC2
1342 52C0
1343 52C0                       ENDP 
1344 52C0
1345 52C0                       title 'UpdateCursor' 
1346 52C0              ****************************************************************
1347 52C0              *
1348 52C0              UpdateCursor PROC EXPORT 
1349 52C0              *
1350 52C0              * This routine is called through a vector in bank E1.  When
1351 52C0              * I get control, there are three bytes of return address info
1352 52C0              * on the stack followed by 4 bytes of mouse information.
1353 52C0              *
1354 52C0              * The calling routine expects me to clean the inputs
1355 52C0              * off the stack.
1356 52C0              *
1357 52C0              * This routine checks the UseInterrupts flag on zero page
1358 52C0              * to decide whether to draw the cursor immediately or
1359 52C0              * arrange for an intterupt to occur later.
1360 52C0              *
1361 52C0              * If I arrange for later, this routine puts the next
1362 52C0              * mouse position on zero page and turns on interrupts for
1363 52C0              * the scan line the mouse is going to be on.
1364 52C0              *
1365 52C0              * Notes:
1366 52C0              *        The interrupt service routine will always clear
1367 52C0              *        the SCB so that only one line has the int on it
1368 52C0              *        at a time.
1369 52C0              *
1370 52C0              *
1371 52C0              *
1372 52C0              * Inputs:
1373 52C0              *	direct page and stack
1374 52C0              *          Stack
1375 52C0              *	MouseX : word
1376 52C0              *	MouseY : word
1377 52C0              *
1378 52C0              *
1379 52C0              * Outputs:
1380 52C0              *	none
1381 52C0              *
1382 52C0              * External Refs:
1383 52C0                       import HandleCursor 
1384 52C0              *
1385 52C0              * Entry Points:
1386 52C0              *	none
1387 52C0              *
1388 52C0                       longa on                       ; mode
1389 52C0                       longi on
1390 52C0              *
1391 52C0              * Change History
1392 52C0              *
1393 52C0              * 11 Nov 88	Steven Glass
1394 52C0              *
1395 52C0              * Cursor is marked shielded if it was obscured and it was
1396 52C0              * supposed to be drawn but it was busy.  This prevents it 
1397 52C0              * from being undrawn later when cursor is unshielded.
1398 52C0              *
1399 52C0              * 11 Dec 88	Steven Glass
1400 52C0              *
1401 52C0              * Changed code to call HandleCursor instead of having code in
1402 52C0              * line in both the UpdateCursor and RefreshCursor routines.
1403 52C0              *
1404 52C0              * 24 Apr 89	Steven Glass
1405 52C0              *
1406 52C0              * Fixed bug introduced on 11 Dec where nextMouse was not
1407 52C0              * updated if UseInterrupts was zero.
1408 52C0              *
1409 52C0              ****************************************************************
1410 52C0
1411 52C0
1412 52C0              OrigDirect equ   1
1413 52C0              WorkAreaRef equ   OrigDirect+2
1414 52C0              RTLAdr   equ   WorkAreaRef+4
1415 52C0              TheMouseY equ   RTLAdr+3
1416 52C0              TheMouseX equ   TheMouseY+2
1417 52C0
1418 52C0
1419 52C0
1420 52C0              ;-------------------------------------------------
1421 52C0              ;
1422 52C0              ; Find our zero page.
1423 52C0              ;
1424 52C0 AF CA 03 E1           lda   >WAPTPtr+2
1425 52C4 48                    pha   
1426 52C5 AF C8 03 E1           lda   >WAPTPtr
1427 52C9 48                    pha   
1428 52CA
1429 52CA 0B                    phd   
1430 52CB 3B                    tsc   
1431 52CC 5B                    tcd   
1432 52CD
1433 52CD A0 10 00              ldy   #16
1434 52D0 B7 03                 lda   [WorkAreaRef],y
1435 52D2 F0 36                 beq   CleanUp                  ; not initialized so quit
1436 52D4
1437 52D4 18                    clc                            ; now add $100
1438 52D5 69 00 01              adc   #$100                    ; and put in direct reg
1439 52D8 5B                    tcd   
1440 52D9
1441 52D9              ; 26 Apr 89 Mensch and Steve Glass
1442 52D9              ; This routine was not clearing the proper scan line interupt after the 4/24 fix.
1443 52D9              ; due to nextMouseY being updated too soon. This is no longer the case. Also, the
1444 52D9              ; ClearSCB routine is called ALL the time now if you have interupts turned on
1445 52D9              ; (this is due to the fact that it can't every hurt to clear the interupt cause it
1446 52D9              ; belongs to us, and we set it again anyway)
1447 52D9 24 52                 bit   UseInterrupts            ; see if interupt use is turned on
1448 52DB 10 03                 bpl   @SkipClear               ; if not, then user has scan ints, so don't clear
1449 52DD 20 7A 53              jsr   ClearSCB                 ; always clear the interupt flag no matter what.
1450 52E0              @SkipClear  
1451 52E0              ;
1452 52E0              ; Copy new mouse location to direct page (before testing useInterrupts).
1453 52E0              ; 24 Apr 89  SEG
1454 52E0              ;
1455 52E0 A3 0C                 lda   TheMouseX,s
1456 52E2 85 5C                 sta   NextMouseX
1457 52E4 A3 0A                 lda   TheMouseY,s
1458 52E6 85 5A                 sta   NextMouseY
1459 52E8
1460 52E8              ;
1461 52E8              ; Check the useinterrupts flag.
1462 52E8              ;
1463 52E8 24 52                 bit   UseInterrupts
1464 52EA 10 1B                 bpl   DoItNow
1465 52EC              ;
1466 52EC              ; Code was this:
1467 52EC              ;	lda	IntPending
1468 52EC              ;	beq	NoIntPending
1469 52EC              ;	jsr	ClearSCB
1470 52EC              ;
1471 52EC              ;NoIntPending
1472 52EC              ; The next line would be needed if you put back the others.
1473 52EC              ;	lda	NextMouseY	; Get value back in Y. 24 Apr 89 SEG
1474 52EC
1475 52EC C9 C8 00              cmp   #200                     ; mouse positions greater than
1476 52EF 90 03                 bcc   Less200                  ; 199 are treated as 0
1477 52F1 A9 00 00              lda   #0
1478 52F4
1479 52F4 AA           Less200  tax                            ; note that I don't bother
1480 52F5 BF 00 9D E1           lda   >FirstSCB,x              ; switching to 8 bit mode!
1481 52F9 09 40 00              ora   #%01000000               ; turn on the int bit in this byte
1482 52FC 9F 00 9D E1           sta   >FirstSCB,x
1483 5300
1484 5300 A9 00 80              lda   #$8000
1485 5303 85 54                 sta   IntPending
1486 5305
1487 5305 80 03                 bra   CleanUp
1488 5307
1489 5307
1490 5307 20 42 53     DoItNow  jsr   HandleCursor
1491 530A
1492 530A              CleanUp                                 ; 
1493 530A 2B                    pld   
1494 530B
1495 530B 68                    pla   
1496 530C 68                    pla   
1497 530D
1498 530D
1499 530D 8B                    phb                            ; put extra byte on stack
1500 530E FA                    plx                            ; pull bank and low byte of rtl
1501 530F 7A                    ply                            ; pull high word of rtl
1502 5310 68                    pla                            ; pull off MouseY and ignore it
1503 5311 68                    pla                            ; pull off MouseX and ignore it
1504 5312 5A                    phy                            ; put back high word of rtl
1505 5313 DA                    phx                            ; put back low byte of rtl and bank
1506 5314 AB                    plb                            ; pull off bank
1507 5315 6B                    rtl   
1508 5316
1509 5316                       ENDP 
1510 5316
1511 5316
1512 5316                       title 'Refresh Cursor' 
1513 5316              ****************************************************************
1514 5316              *
1515 5316              RefreshCursor PROC EXPORT 
1516 5316              *
1517 5316              * This is the interrupt handling routine that is called
1518 5316              * when a scan line interrupt occurs.
1519 5316              *
1520 5316              * It is called in 8 bit native mode, and must return that way.
1521 5316              *
1522 5316              * This routine must clear the interrupt flag in the scb.
1523 5316              *
1524 5316              *
1525 5316              *
1526 5316              * Inputs:
1527 5316              *	direct page
1528 5316              *
1529 5316              * Outputs:
1530 5316              *	none
1531 5316              *
1532 5316              * External Refs:
1533 5316                       import HandleCursor 
1534 5316              *
1535 5316              * Entry Points:
1536 5316              *	none
1537 5316              *
1538 5316                       longa on                       ; mode
1539 5316                       longi on
1540 5316              *
1541 5316              * Change History
1542 5316              *
1543 5316              * 11 Nov 88	Steven Glass
1544 5316              *
1545 5316              * Cursor is marked shielded if it was obscured and it was
1546 5316              * supposed to be drawn but it was busy.  This prevents it from being undrawn
1547 5316              * later when cursor is unshielded.
1548 5316              *
1549 5316              ****************************************************************
1550 5316
1551 5316
1552 5316              OrigDirect equ   1
1553 5316              WorkAreaRef equ   OrigDirect+2
1554 5316              OrigP    equ   WorkAreaRef+4
1555 5316              RTLAdr   equ   OrigP+2
1556 5316
1557 5316
1558 5316              ;------------------------------------------------------
1559 5316              ;
1560 5316              ; First switch to full native mode
1561 5316              ;
1562 5316
1563 5316 08                    php                            ; save state
1564 5317 C2 30                 rep   #$30
1565 5319
1566 5319              ;------------------------------------------------------
1567 5319              ;
1568 5319              ; Find our zero page.
1569 5319              ;
1570 5319 AF CA 03 E1           lda   >WAPTPtr+2
1571 531D 48                    pha   
1572 531E AF C8 03 E1           lda   >WAPTPtr
1573 5322 48                    pha   
1574 5323
1575 5323 0B                    phd   
1576 5324 3B                    tsc   
1577 5325 5B                    tcd   
1578 5326
1579 5326 A0 10 00              ldy   #16
1580 5329 B7 03                 lda   [WorkAreaRef],y
1581 532B
1582 532B 18                    clc                            ; now add $100
1583 532C 69 00 01              adc   #$100                    ; and put in direct reg
1584 532F 5B                    tcd   
1585 5330
1586 5330              ;------------------------------------------------------
1587 5330              ;
1588 5330              ; Clear the interrupting SCB.
1589 5330              ;
1590 5330 20 7A 53              jsr   ClearSCB
1591 5333
1592 5333
1593 5333 20 42 53              jsr   HandleCursor
1594 5336
1595 5336 2B                    pld   
1596 5337
1597 5337 68                    pla   
1598 5338 68                    pla   
1599 5339
1600 5339
1601 5339 28                    plp                            ; Now back in 8 bit mode
1602 533A
1603 533A
1604 533A              ;------------------------------------------------------
1605 533A              ;
1606 533A              ; Now I have to clear the interrupt
1607 533A              ; by writing to the interrupt status register in VGC
1608 533A              ; Bit 5 is the flag for scan line ints.
1609 533A              ;
1610 533A                       longa off
1611 533A                       longi off
1612 533A
1613 533A A9 DF                 lda   #%11011111               ; clear bit 5
1614 533C 8F 32 C0 00           sta   >ScanInt                 ;
1615 5340
1616 5340 18                    clc                            ; tell the calling program
1617 5341 6B                    rtl                            ; that I serviced it.
1618 5342
1619 5342                       longa on
1620 5342                       longi on
1621 5342
1622 5342                       ENDP 
1623 5342
1624 5342                       title 'HandleCursor' 
1625 5342              ****************************************************************
1626 5342              *
1627 5342              HandleCursor PROC 
1628 5342              *
1629 5342              * Called by both RefreshCursor and UpdateCursor to 
1630 5342              * undraw and draw the cursor on the screen.
1631 5342              *
1632 5342              *
1633 5342              *
1634 5342              * Inputs:
1635 5342              *	all on d-page
1636 5342              *
1637 5342              * Outputs:
1638 5342              *	all on d-page
1639 5342              *
1640 5342              * External Refs:
1641 5342              *	none
1642 5342              *
1643 5342              * Entry Points:
1644 5342              *	none
1645 5342              *
1646 5342                       longa on                       ; mode
1647 5342                       longi on
1648 5342              *
1649 5342              *
1650 5342              * Change History
1651 5342              *
1652 5342              * 11 Dec 88	Steven Glass
1653 5342              *
1654 5342              * Added on today to remove code duplication and make it
1655 5342              * less costly to patch old ROM's.
1656 5342              *
1657 5342              ****************************************************************
1658 5342
1659 5342              ;------------------------------------------------------
1660 5342              ;
1661 5342              ; Now see if we have to undraw.
1662 5342              ;
1663 5342
1664 5342 24 EE                 bit   CursorFlags
1665 5344 30 0C                 bmi   NotVis1
1666 5346
1667 5346 24 CC                 bit   CursorLevel
1668 5348 30 08                 bmi   NotVis1
1669 534A 24 CE                 bit   ObscureFlag
1670 534C 30 04                 bmi   NotVis1
1671 534E
1672 534E              ;-------------------------------------------------
1673 534E              ;
1674 534E              ; Undraw last one
1675 534E              ;
1676 534E
1677 534E 22 D0 1F E0           jsl   UnDrawCursor
1678 5352
1679 5352
1680 5352
1681 5352              ;-------------------------------------------------
1682 5352              ;
1683 5352              ; Set new mouse pos
1684 5352              ;
1685 5352 A5 5A        NotVis1  lda   NextMouseY
1686 5354 85 56                 sta   MouseY
1687 5356 A5 5C                 lda   NextMouseX
1688 5358 85 58                 sta   MouseX
1689 535A
1690 535A 24 CC                 bit   CursorLevel
1691 535C 30 0C                 bmi   NotVis2
1692 535E A5 CE                 lda   ObscureFlag
1693 5360 64 CE                 stz   ObscureFlag
1694 5362
1695 5362
1696 5362 24 EE                 bit   CursorFlags
1697 5364 30 06                 bmi   ForceUpdate
1698 5366
1699 5366              ;-------------------------------------------------
1700 5366              ;
1701 5366              ; Draw it in new place
1702 5366              ;
1703 5366 22 CC 1F E0           jsl   DrawCursor
1704 536A
1705 536A              NotVis2                                 ; 
1706 536A              SkipIt                                  ; 
1707 536A 80 0D                 bra   CleanUp
1708 536C
1709 536C              ForceUpdate  
1710 536C AA                    tax                            ; was the cursor obscured?
1711 536D F0 05                 beq   @No
1712 536F
1713 536F A9 00 40              lda   #shielded_m              ; it was obscured, so now it must be considered
1714 5372 04 EE                 tsb   CursorFlags              ; as shielded.
1715 5374
1716 5374              @No       
1717 5374 A9 00 20              lda   #ForceU_M                ; since i did not draw it
1718 5377 04 EE                 tsb   CursorFlags              ; force the draw at time of
1719 5379              ;                                       ; unshield cursor
1720 5379
1721 5379
1722 5379              CleanUp                                 ; 
1723 5379 60                    rts   
1724 537A
1725 537A                       ENDP 
1726 537A
1727 537A
1728 537A                       title 'ClearSCB' 
1729 537A              ****************************************************************
1730 537A              *
1731 537A              ClearSCB PROC EXPORT 
1732 537A              *
1733 537A              * Clears the interrupt request from the SCB.
1734 537A              *
1735 537A              *
1736 537A              * Inputs:
1737 537A              *	direct page.
1738 537A              *
1739 537A              * Outputs:
1740 537A              *	none
1741 537A              *
1742 537A              * External Refs:
1743 537A              *	none
1744 537A              *
1745 537A              * Entry Points:
1746 537A              *	none
1747 537A              *
1748 537A                       longa on                       ; mode
1749 537A                       longi on
1750 537A              *
1751 537A              ****************************************************************
1752 537A
1753 537A
1754 537A A5 5A                 lda   NextMouseY
1755 537C
1756 537C C9 C8 00              cmp   #200                     ; mouse positions greater than
1757 537F 90 03                 bcc   Less200                  ; 199 are treated as 0
1758 5381 A9 00 00              lda   #0
1759 5384
1760 5384 AA           Less200  tax                            ; note that I don't bother
1761 5385 BF 00 9D E1           lda   >FirstSCB,x              ; switching to 8 bit mode!
1762 5389 29 BF FF              and   #%1111111110111111       ; turn off the int bit in this byte
1763 538C 9F 00 9D E1           sta   >FirstSCB,x
1764 5390
1765 5390 64 54                 stz   IntPending
1766 5392
1767 5392 60                    rts   
1768 5393
1769 5393                       ENDP 
1770 5393
1771 5393                       title 'DrawCursor' 
1772 5393              ****************************************************************
1773 5393              *
1774 5393              * iDrawCursor
1775 5393              *
1776 5393              * What the hey, this draws the cursor at the position
1777 5393              * indicated on zp.
1778 5393              *
1779 5393              * Change History
1780 5393              *
1781 5393              * 21 Aug 86     SEG      The calculation of the saveRect was
1782 5393              *	     wrong.  A test for which mode branched
1783 5393              *	     wrong for the 2 possible cases making
1784 5393              *	     the 320 mode save rect too big and the
1785 5393              *	     640 mode save rect too small.
1786 5393              *
1787 5393              *	     There is a calculation where I must add
1788 5393              *	     8 to a value. I know the carry is set
1789 5393              *	     so I saved a byte and added 7 without
1790 5393              *	     touching the carry.
1791 5393              *
1792 5393              * 2/1/89	Mensch
1793 5393              *
1794 5393              * Added support for shadowed bank cursor...
1795 5393              *
1796 5393              ****************************************************************
1797 5393              iDrawCursor PROC EXPORT 
1798 5393                       import ScreenTable 
1799 5393
1800 5393              ;-------------------------------------------------
1801 5393              ;
1802 5393
1803 5393              ; First we set up the bank.
1804 5393
1805 5393 8B                    phb                            ; save the current bank
1806 5394              ;
1807 5394              ; Find out if we are shadowed...
1808 5394 AF 35 C0 E0           lda   >$E0C035                 ; get the shadow register
1809 5398 29 08 00              and   #$0008                   ; test the shadowing flags!
1810 539B D0 05                 bne   @1                       ; if zero, then shadowing is on
1811 539D F4 01 01              pea   $0101                    ; push on the shadowed bank
1812 53A0 80 03                 bra   @2
1813 53A2
1814 53A2 F4 E1 E1     @1       pea   $E1E1                    ; push this on stack
1815 53A5 AB           @2       plb                            ; set bank twice to
1816 53A6 AB                    plb                            ; clear stack
1817 53A7
1818 53A7
1819 53A7
1820 53A7              ;-------------------------------------------------
1821 53A7              ;
1822 53A7              ; Next we set up the cursor rectangle
1823 53A7
1824 53A7 A5 56                 lda   MouseY
1825 53A9 38                    sec   
1826 53AA E5 C2                 sbc   HotSpot
1827 53AC 85 62                 sta   CursorY1
1828 53AE 85 F8                 sta   SaveRect
1829 53B0 85 D6                 sta   CurrentY
1830 53B2 18                    clc   
1831 53B3 65 5E                 adc   CurHeight
1832 53B5 85 66                 sta   CursorY2
1833 53B7 85 FC                 sta   SaveRect+4
1834 53B9
1835 53B9 A5 58                 lda   MouseX
1836 53BB 38                    sec   
1837 53BC E5 C4                 sbc   HotSpot+2
1838 53BE 85 64                 sta   CursorX1
1839 53C0 85 FA                 sta   SaveRect+2
1840 53C2
1841 53C2 A5 60                 lda   CurWidth                 ; get width in words
1842 53C4 0A                    asl   a                        ; make it  bytes
1843 53C5 0A                    asl   a                        ; make it pixels for 320 mode
1844 53C6
1845 53C6 24 69                 bit   CursorMode-1
1846 53C8 10 01                 bpl   Width320                 ; Fixed 21 Aug 86
1847 53CA 0A                    asl   a
1848 53CB 18           Width320 clc   
1849 53CC 65 64                 adc   CursorX1
1850 53CE 85 68                 sta   CursorX2
1851 53D0 85 FE                 sta   SaveRect+6
1852 53D2
1853 53D2
1854 53D2              ;-----------------------------------------------
1855 53D2              ;
1856 53D2              ; Now I calculate the real bounds of the 
1857 53D2              ; SaveRect.
1858 53D2              ;  
1859 53D2 18                    clc                            ; clear carry for use later
1860 53D3 A9 FC FF              lda   #%1111111111111100       ; load a with mask for 320 mode
1861 53D6 24 69                 bit   CursorMode-1             ; check real mode
1862 53D8 10 01                 bpl   Still320                 ; if not 320 mode put one more
1863 53DA 0A                    asl   a                        ; zero at low and and set carry!
1864 53DB A8           Still320 tay                            ; put copy of mask in y
1865 53DC 25 FA                 and   SaveRect+2               ; and with left edge of rect
1866 53DE 85 FA                 sta   SaveRect+2               ; and save it
1867 53E0 98                    tya                            ; get make back
1868 53E1 25 FE                 and   SaveRect+6               ; and with right edge
1869 53E3 B0 05                 bcs   Still640                 ; if carry is clear then we know
1870 53E5 69 04 00              adc   #4                       ; that we were in 320 mode
1871 53E8 80 03                 bra   SaveRtEdge               ; so add 4 and save rt edge
1872 53EA              Still640                                ; ; otherwise add 8 and save rt edge
1873 53EA 69 07 00              adc   #7                       ; note that carry was set to get here
1874 53ED              ;                                       ; and adding 7 with carry set is like
1875 53ED              ;                                       ; adding 8. (sorry to those who follow)
1876 53ED              ;                                       ; This changed on
1877 53ED              ;                                       ;    Aug 21, 1986
1878 53ED              ;                                       ; by SEG
1879 53ED
1880 53ED 85 FE        SaveRtEdge sta   SaveRect+6
1881 53EF
1882 53EF
1883 53EF              ;-------------------------------------------------
1884 53EF              ;
1885 53EF              ; Set up the StartWord (we don't use FinishWord) then 
1886 53EF              ; Figure out which preshifted image to use and put
1887 53EF              ; pointer to it in CursorRef and MaskRef.
1888 53EF              ;
1889 53EF 24 69                 bit   CursorMode-1
1890 53F1 30 12                 bmi   Mode640
1891 53F3
1892 53F3 A5 64                 lda   CursorX1                 ; make x value into byte
1893 53F5 0A                    asl   a                        ; get sign into c
1894 53F6 A5 64                 lda   CursorX1
1895 53F8 6A                    ror   a                        ; preserve sign
1896 53F9 29 FE FF              and   #$FFFE                   ; make even
1897 53FC 85 D0                 sta   StartWord
1898 53FE
1899 53FE A5 64                 lda   CursorX1                 ; which preshifted image do I use?
1900 5400 29 03 00              and   #3
1901 5403 80 13                 bra   GetReady
1902 5405
1903 5405
1904 5405              Mode640                                 ; 
1905 5405 A5 64                 lda   CursorX1                 ; make x value into byte
1906 5407 0A                    asl   a                        ; get sign into c
1907 5408 08                    php                            ; and save it
1908 5409 A5 64                 lda   CursorX1
1909 540B 6A                    ror   a                        ; preserve sign
1910 540C 28                    plp   
1911 540D 6A                    ror   a                        ; rotate again preserving sign
1912 540E 29 FE FF              and   #$FFFE                   ; make even
1913 5411 85 D0                 sta   StartWord
1914 5413
1915 5413 A5 64                 lda   CursorX1                 ; determin which of the preshifted
1916 5415 29 07 00              and   #7                       ; images to use
1917 5418
1918 5418 0A           GetReady asl   a                        ; use number in a as index into
1919 5419 0A                    asl   a                        ; pointers on zp
1920 541A 0A                    asl   a
1921 541B AA                    tax   
1922 541C
1923 541C B5 70                 lda   CursorPtr,x
1924 541E 85 BA                 sta   CursorRef
1925 5420 B5 71                 lda   CursorPtr+1,x
1926 5422 85 BB                 sta   CursorRef+1
1927 5424
1928 5424 B5 74                 lda   MaskPtr,x
1929 5426 85 BE                 sta   MaskRef
1930 5428 B5 75                 lda   MaskPtr+1,x
1931 542A 85 BF                 sta   MaskRef+1
1932 542C
1933 542C              ;-------------------------------------------------
1934 542C              ;
1935 542C              ; Set up other important vars for looping.
1936 542C              ;
1937 542C
1938 542C A5 B4                 lda   SavePtr                  ; put the pointer to the beginning
1939 542E 85 C6                 sta   SaveRef                  ; of the save area into SaveRef
1940 5430 A5 B5                 lda   SavePtr+1                ; (which will be bumped for each 
1941 5432 85 C7                 sta   SaveRef+1                ; scan line)
1942 5434
1943 5434
1944 5434 A5 62                 lda   CursorY1
1945 5436 85 D6                 sta   CurrentY
1946 5438
1947 5438
1948 5438              ;-------------------------------------------------
1949 5438              ;
1950 5438              ; The Outer Loop
1951 5438              ;
1952 5438              ;    For each scan line (CursorY1 thru CursorY2)
1953 5438              ;
1954 5438              OuterLoop                               ; 
1955 5438 A5 D6                 lda   CurrentY
1956 543A 10 03                 bpl   NotAbove
1957 543C 4C 98 54              jmp   BumpVertCounters
1958 543F
1959 543F C9 C8 00     NotAbove cmp   #ScreenHeight
1960 5442 30 03                 bmi   NotBelow
1961 5444 4C B4 54              jmp   AllDone
1962 5447
1963 5447 C5 66        NotBelow cmp   CursorY2
1964 5449 30 03                 bmi   YesDoIt
1965 544B 4C B4 54              jmp   AllDone
1966 544E
1967 544E              YesDoIt                                 ; 
1968 544E
1969 544E              ;-------------------------------------------------
1970 544E              ;
1971 544E              ; Now I set up the loop to save the screen,
1972 544E              ; or in the mask and eor in the cursor all in
1973 544E              ; one loop
1974 544E              ;
1975 544E A5 60                 lda   CurWidth                 ; init the word count again (1 more
1976 5450 3A                    dec   a
1977 5451 85 E8                 sta   WordCount                ; than before)
1978 5453
1979 5453 A5 D0                 lda   StartWord                ; Screen Index starts at start word
1980 5455 85 D2                 sta   ScreenIndex
1981 5457
1982 5457 A5 D6                 lda   CurrentY                 ; ScreenRef is created from current
1983 5459 0A                    asl   a                        ; Y
1984 545A AA                    tax   
1985 545B BF 3C 55 FE           lda   >ScreenTable,x
1986 545F 85 CA                 sta   ScreenRef
1987 5461
1988 5461 64 D4                 stz   SaveIndex                ; Save index starts at zero
1989 5463
1990 5463
1991 5463 A4 D2        DrawLoop ldy   ScreenIndex              ; get screen index
1992 5465 30 27                 bmi   OffScrnH                 ; and see if it points ot real
1993 5467 C0 A0 00              cpy   #ScreenWidth             ; screen
1994 546A 10 22                 bpl   OffScrnH
1995 546C
1996 546C B1 CA                 lda   (ScreenRef),y            ; Save under cursor
1997 546E A4 D4                 ldy   SaveIndex                ; put in save buffer
1998 5470 97 C6                 sta   [SaveRef],y
1999 5472
2000 5472 B7 BE                 lda   [MaskRef],y              ; get word from mask
2001 5474
2002 5474 BB                    tyx                            ; save this here for quick access
2003 5475
2004 5475
2005 5475 A4 D2                 ldy   ScreenIndex              ; get this back
2006 5477 11 CA                 ora   (ScreenRef),y            ; or with screen
2007 5479 9B                    txy   
2008 547A 57 BA                 eor   [CursorRef],y            ; eor with rotated cursor
2009 547C A4 D2                 ldy   ScreenIndex
2010 547E 91 CA                 sta   (ScreenRef),y            ; store in screen
2011 5480
2012 5480 E8                    inx                            ; bump this now that is in a register
2013 5481 E8                    inx                            ; register
2014 5482 86 D4                 stx   SaveIndex
2015 5484 C8                    iny                            ; bump this now since it is in a
2016 5485 C8                    iny                            ; register
2017 5486 84 D2                 sty   ScreenIndex
2018 5488
2019 5488 C6 E8        FinishLoop dec   WordCount              ; dec the word count and
2020 548A 10 D7                 bpl   DrawLoop                 ; repeat till done
2021 548C 80 0A                 bra   BumpVertCounters         ; now bump vert counters
2022 548E
2023 548E
2024 548E E6 D2        OffScrnH inc   ScreenIndex              ; These were not bumped
2025 5490 E6 D2                 inc   ScreenIndex              ; in loop since cursor was clipped
2026 5492 E6 D4                 inc   SaveIndex
2027 5494 E6 D4                 inc   SaveIndex
2028 5496 80 F0                 bra   FinishLoop
2029 5498
2030 5498
2031 5498              BumpVertCounters                        ; 
2032 5498 E6 D6                 inc   CurrentY
2033 549A
2034 549A A5 60                 lda   CurWidth                 ; use this to calc width
2035 549C 0A                    asl   a
2036 549D AA                    tax                            ; save in x
2037 549E 18                    clc                            ; add to cursor ref
2038 549F 65 BA                 adc   CursorRef
2039 54A1 85 BA                 sta   CursorRef
2040 54A3
2041 54A3 8A                    txa                            ; add to mask ref
2042 54A4 18                    clc   
2043 54A5 65 BE                 adc   MaskRef
2044 54A7 85 BE                 sta   MaskRef
2045 54A9
2046 54A9 8A                    txa                            ; inc once and add to SaveRef
2047 54AA 1A                    inc   a
2048 54AB 1A                    inc   a
2049 54AC 18                    clc   
2050 54AD 65 C6                 adc   SaveRef
2051 54AF 85 C6                 sta   SaveRef
2052 54B1
2053 54B1
2054 54B1 4C 38 54              jmp   OuterLoop
2055 54B4
2056 54B4              AllDone   
2057 54B4 AB                    plb                            ; restore stack
2058 54B5 6B                    rtl   
2059 54B6
2060 54B6                       ENDP 
2061 54B6
2062 54B6                       title 'UndrawCursor' 
2063 54B6              ****************************************************************
2064 54B6              *
2065 54B6              * iUndrawCursor
2066 54B6              *
2067 54B6              *
2068 54B6              * 2/1/89	Mensch
2069 54B6              *
2070 54B6              * Added use of shadowed bank if shadowing is enabled...
2071 54B6              *
2072 54B6              ****************************************************************
2073 54B6              iUndrawCursor PROC EXPORT 
2074 54B6                       import ScreenTable 
2075 54B6
2076 54B6 8B                    phb                            ; save the current bank
2077 54B7              ;
2078 54B7              ; Find out if we are shadowed...
2079 54B7 AF 35 C0 E0           lda   >$E0C035                 ; get the shadow register
2080 54BB 29 08 00              and   #$0008                   ; test the shadowing flags!
2081 54BE D0 05                 bne   @1                       ; if zero, then shadowing is on
2082 54C0 F4 01 01              pea   $0101                    ; push on the shadowed bank
2083 54C3 80 03                 bra   @2
2084 54C5
2085 54C5 F4 E1 E1     @1       pea   $E1E1                    ; push this on stack
2086 54C8 AB           @2       plb                            ; set bank twice to
2087 54C9 AB                    plb                            ; clear stack
2088 54CA
2089 54CA
2090 54CA A5 62                 lda   CursorY1
2091 54CC 85 D6                 sta   CurrentY
2092 54CE
2093 54CE A5 B4                 lda   SavePtr
2094 54D0 85 C6                 sta   SaveRef
2095 54D2 A5 B5                 lda   SavePtr+1
2096 54D4 85 C7                 sta   SaveRef+1
2097 54D6
2098 54D6 64 D4                 stz   SaveIndex                ; start this at zero and do not reset it
2099 54D8
2100 54D8              OuterLoop                               ; 
2101 54D8 A5 D6                 lda   CurrentY
2102 54DA 10 03                 bpl   NotAbove
2103 54DC 4C 2C 55              jmp   BumpVertCounters
2104 54DF
2105 54DF C9 C8 00     NotAbove cmp   #ScreenHeight
2106 54E2 30 03                 bmi   NotBelow
2107 54E4 4C 3A 55              jmp   AllDone
2108 54E7
2109 54E7 C5 66        NotBelow cmp   CursorY2
2110 54E9 30 03                 bmi   YesDoIt
2111 54EB 4C 3A 55              jmp   AllDone
2112 54EE
2113 54EE              YesDoIt                                 ; 
2114 54EE
2115 54EE
2116 54EE A5 60                 lda   CurWidth                 ; init the word count
2117 54F0 3A                    dec   a
2118 54F1 85 E8                 sta   WordCount
2119 54F3
2120 54F3 A5 D0                 lda   StartWord                ; Screen Index starts at start word
2121 54F5 85 D2                 sta   ScreenIndex
2122 54F7
2123 54F7 A5 D6                 lda   CurrentY                 ; ScreenRef is created from current
2124 54F9 0A                    asl   a                        ; Y
2125 54FA AA                    tax   
2126 54FB BF 3C 55 FE           lda   >ScreenTable,x
2127 54FF 85 CA                 sta   ScreenRef
2128 5501
2129 5501 64 D4                 stz   SaveIndex                ; Save index starts at zero
2130 5503
2131 5503
2132 5503 A4 D2        DrawLoop ldy   ScreenIndex              ; get screen index
2133 5505 30 1B                 bmi   OffScrnH                 ; and see if it points ot real
2134 5507 C0 A0 00              cpy   #ScreenWidth             ; screen
2135 550A 10 16                 bpl   OffScrnH
2136 550C
2137 550C BB                    tyx   
2138 550D A4 D4                 ldy   SaveIndex                ; get from save buffer
2139 550F B7 C6                 lda   [SaveRef],y
2140 5511 C8                    iny   
2141 5512 C8                    iny   
2142 5513 84 D4                 sty   SaveIndex
2143 5515 9B                    txy   
2144 5516 91 CA                 sta   (ScreenRef),y            ; restore under cursor
2145 5518
2146 5518 C8                    iny                            ; bump this now since it is in a
2147 5519 C8                    iny                            ; register
2148 551A 84 D2                 sty   ScreenIndex
2149 551C
2150 551C C6 E8        FinishLoop dec   WordCount              ; dec the word count and
2151 551E 10 E3                 bpl   DrawLoop                 ; repeat till done
2152 5520 80 0A                 bra   BumpVertCounters         ; now bump vert counters
2153 5522
2154 5522
2155 5522 E6 D2        OffScrnH inc   ScreenIndex              ; These were not bumped
2156 5524 E6 D2                 inc   ScreenIndex              ; in loop since cursor was clipped
2157 5526 E6 D4                 inc   SaveIndex
2158 5528 E6 D4                 inc   SaveIndex
2159 552A 80 F0                 bra   FinishLoop
2160 552C
2161 552C
2162 552C              BumpVertCounters                        ; 
2163 552C E6 D6                 inc   CurrentY
2164 552E
2165 552E A5 60                 lda   CurWidth                 ; use this to calc width
2166 5530 1A                    inc   a                        ; of pixel maps
2167 5531 0A                    asl   a
2168 5532
2169 5532 18                    clc   
2170 5533 65 C6                 adc   SaveRef
2171 5535 85 C6                 sta   SaveRef
2172 5537
2173 5537
2174 5537 4C D8 54              jmp   OuterLoop
2175 553A
2176 553A
2177 553A
2178 553A              AllDone   
2179 553A AB                    plb                            ; restore stack
2180 553B 6B                    rtl   
2181 553C                       ENDP 
2182 553C
2183 553C                       title 'ScreenTable' 
2184 553C              ScreenTable  PROC EXPORT 
2185 553C
2186 553C 00 20                 DC W:0*160+ScreenStart
2187 553E A0 20                 DC W:1*160+ScreenStart
2188 5540 40 21                 DC W:2*160+ScreenStart
2189 5542 E0 21                 DC W:3*160+ScreenStart
2190 5544 80 22                 DC W:4*160+ScreenStart
2191 5546 20 23                 DC W:5*160+ScreenStart
2192 5548 C0 23                 DC W:6*160+ScreenStart
2193 554A 60 24                 DC W:7*160+ScreenStart
2194 554C 00 25                 DC W:8*160+ScreenStart
2195 554E A0 25                 DC W:9*160+ScreenStart
2196 5550 40 26                 DC W:10*160+ScreenStart
2197 5552 E0 26                 DC W:11*160+ScreenStart
2198 5554 80 27                 DC W:12*160+ScreenStart
2199 5556 20 28                 DC W:13*160+ScreenStart
2200 5558 C0 28                 DC W:14*160+ScreenStart
2201 555A 60 29                 DC W:15*160+ScreenStart
2202 555C 00 2A                 DC W:16*160+ScreenStart
2203 555E A0 2A                 DC W:17*160+ScreenStart
2204 5560 40 2B                 DC W:18*160+ScreenStart
2205 5562 E0 2B                 DC W:19*160+ScreenStart
2206 5564 80 2C                 DC W:20*160+ScreenStart
2207 5566 20 2D                 DC W:21*160+ScreenStart
2208 5568 C0 2D                 DC W:22*160+ScreenStart
2209 556A 60 2E                 DC W:23*160+ScreenStart
2210 556C 00 2F                 DC W:24*160+ScreenStart
2211 556E A0 2F                 DC W:25*160+ScreenStart
2212 5570 40 30                 DC W:26*160+ScreenStart
2213 5572 E0 30                 DC W:27*160+ScreenStart
2214 5574 80 31                 DC W:28*160+ScreenStart
2215 5576 20 32                 DC W:29*160+ScreenStart
2216 5578 C0 32                 DC W:30*160+ScreenStart
2217 557A 60 33                 DC W:31*160+ScreenStart
2218 557C 00 34                 DC W:32*160+ScreenStart
2219 557E A0 34                 DC W:33*160+ScreenStart
2220 5580 40 35                 DC W:34*160+ScreenStart
2221 5582 E0 35                 DC W:35*160+ScreenStart
2222 5584 80 36                 DC W:36*160+ScreenStart
2223 5586 20 37                 DC W:37*160+ScreenStart
2224 5588 C0 37                 DC W:38*160+ScreenStart
2225 558A 60 38                 DC W:39*160+ScreenStart
2226 558C 00 39                 DC W:40*160+ScreenStart
2227 558E A0 39                 DC W:41*160+ScreenStart
2228 5590 40 3A                 DC W:42*160+ScreenStart
2229 5592 E0 3A                 DC W:43*160+ScreenStart
2230 5594 80 3B                 DC W:44*160+ScreenStart
2231 5596 20 3C                 DC W:45*160+ScreenStart
2232 5598 C0 3C                 DC W:46*160+ScreenStart
2233 559A 60 3D                 DC W:47*160+ScreenStart
2234 559C 00 3E                 DC W:48*160+ScreenStart
2235 559E A0 3E                 DC W:49*160+ScreenStart
2236 55A0 40 3F                 DC W:50*160+ScreenStart
2237 55A2 E0 3F                 DC W:51*160+ScreenStart
2238 55A4 80 40                 DC W:52*160+ScreenStart
2239 55A6 20 41                 DC W:53*160+ScreenStart
2240 55A8 C0 41                 DC W:54*160+ScreenStart
2241 55AA 60 42                 DC W:55*160+ScreenStart
2242 55AC 00 43                 DC W:56*160+ScreenStart
2243 55AE A0 43                 DC W:57*160+ScreenStart
2244 55B0 40 44                 DC W:58*160+ScreenStart
2245 55B2 E0 44                 DC W:59*160+ScreenStart
2246 55B4 80 45                 DC W:60*160+ScreenStart
2247 55B6 20 46                 DC W:61*160+ScreenStart
2248 55B8 C0 46                 DC W:62*160+ScreenStart
2249 55BA 60 47                 DC W:63*160+ScreenStart
2250 55BC 00 48                 DC W:64*160+ScreenStart
2251 55BE A0 48                 DC W:65*160+ScreenStart
2252 55C0 40 49                 DC W:66*160+ScreenStart
2253 55C2 E0 49                 DC W:67*160+ScreenStart
2254 55C4 80 4A                 DC W:68*160+ScreenStart
2255 55C6 20 4B                 DC W:69*160+ScreenStart
2256 55C8 C0 4B                 DC W:70*160+ScreenStart
2257 55CA 60 4C                 DC W:71*160+ScreenStart
2258 55CC 00 4D                 DC W:72*160+ScreenStart
2259 55CE A0 4D                 DC W:73*160+ScreenStart
2260 55D0 40 4E                 DC W:74*160+ScreenStart
2261 55D2 E0 4E                 DC W:75*160+ScreenStart
2262 55D4 80 4F                 DC W:76*160+ScreenStart
2263 55D6 20 50                 DC W:77*160+ScreenStart
2264 55D8 C0 50                 DC W:78*160+ScreenStart
2265 55DA 60 51                 DC W:79*160+ScreenStart
2266 55DC 00 52                 DC W:80*160+ScreenStart
2267 55DE A0 52                 DC W:81*160+ScreenStart
2268 55E0 40 53                 DC W:82*160+ScreenStart
2269 55E2 E0 53                 DC W:83*160+ScreenStart
2270 55E4 80 54                 DC W:84*160+ScreenStart
2271 55E6 20 55                 DC W:85*160+ScreenStart
2272 55E8 C0 55                 DC W:86*160+ScreenStart
2273 55EA 60 56                 DC W:87*160+ScreenStart
2274 55EC 00 57                 DC W:88*160+ScreenStart
2275 55EE A0 57                 DC W:89*160+ScreenStart
2276 55F0 40 58                 DC W:90*160+ScreenStart
2277 55F2 E0 58                 DC W:91*160+ScreenStart
2278 55F4 80 59                 DC W:92*160+ScreenStart
2279 55F6 20 5A                 DC W:93*160+ScreenStart
2280 55F8 C0 5A                 DC W:94*160+ScreenStart
2281 55FA 60 5B                 DC W:95*160+ScreenStart
2282 55FC 00 5C                 DC W:96*160+ScreenStart
2283 55FE A0 5C                 DC W:97*160+ScreenStart
2284 5600 40 5D                 DC W:98*160+ScreenStart
2285 5602 E0 5D                 DC W:99*160+ScreenStart
2286 5604 80 5E                 DC W:100*160+ScreenStart
2287 5606 20 5F                 DC W:101*160+ScreenStart
2288 5608 C0 5F                 DC W:102*160+ScreenStart
2289 560A 60 60                 DC W:103*160+ScreenStart
2290 560C 00 61                 DC W:104*160+ScreenStart
2291 560E A0 61                 DC W:105*160+ScreenStart
2292 5610 40 62                 DC W:106*160+ScreenStart
2293 5612 E0 62                 DC W:107*160+ScreenStart
2294 5614 80 63                 DC W:108*160+ScreenStart
2295 5616 20 64                 DC W:109*160+ScreenStart
2296 5618 C0 64                 DC W:110*160+ScreenStart
2297 561A 60 65                 DC W:111*160+ScreenStart
2298 561C 00 66                 DC W:112*160+ScreenStart
2299 561E A0 66                 DC W:113*160+ScreenStart
2300 5620 40 67                 DC W:114*160+ScreenStart
2301 5622 E0 67                 DC W:115*160+ScreenStart
2302 5624 80 68                 DC W:116*160+ScreenStart
2303 5626 20 69                 DC W:117*160+ScreenStart
2304 5628 C0 69                 DC W:118*160+ScreenStart
2305 562A 60 6A                 DC W:119*160+ScreenStart
2306 562C 00 6B                 DC W:120*160+ScreenStart
2307 562E A0 6B                 DC W:121*160+ScreenStart
2308 5630 40 6C                 DC W:122*160+ScreenStart
2309 5632 E0 6C                 DC W:123*160+ScreenStart
2310 5634 80 6D                 DC W:124*160+ScreenStart
2311 5636 20 6E                 DC W:125*160+ScreenStart
2312 5638 C0 6E                 DC W:126*160+ScreenStart
2313 563A 60 6F                 DC W:127*160+ScreenStart
2314 563C 00 70                 DC W:128*160+ScreenStart
2315 563E A0 70                 DC W:129*160+ScreenStart
2316 5640 40 71                 DC W:130*160+ScreenStart
2317 5642 E0 71                 DC W:131*160+ScreenStart
2318 5644 80 72                 DC W:132*160+ScreenStart
2319 5646 20 73                 DC W:133*160+ScreenStart
2320 5648 C0 73                 DC W:134*160+ScreenStart
2321 564A 60 74                 DC W:135*160+ScreenStart
2322 564C 00 75                 DC W:136*160+ScreenStart
2323 564E A0 75                 DC W:137*160+ScreenStart
2324 5650 40 76                 DC W:138*160+ScreenStart
2325 5652 E0 76                 DC W:139*160+ScreenStart
2326 5654 80 77                 DC W:140*160+ScreenStart
2327 5656 20 78                 DC W:141*160+ScreenStart
2328 5658 C0 78                 DC W:142*160+ScreenStart
2329 565A 60 79                 DC W:143*160+ScreenStart
2330 565C 00 7A                 DC W:144*160+ScreenStart
2331 565E A0 7A                 DC W:145*160+ScreenStart
2332 5660 40 7B                 DC W:146*160+ScreenStart
2333 5662 E0 7B                 DC W:147*160+ScreenStart
2334 5664 80 7C                 DC W:148*160+ScreenStart
2335 5666 20 7D                 DC W:149*160+ScreenStart
2336 5668 C0 7D                 DC W:150*160+ScreenStart
2337 566A 60 7E                 DC W:151*160+ScreenStart
2338 566C 00 7F                 DC W:152*160+ScreenStart
2339 566E A0 7F                 DC W:153*160+ScreenStart
2340 5670 40 80                 DC W:154*160+ScreenStart
2341 5672 E0 80                 DC W:155*160+ScreenStart
2342 5674 80 81                 DC W:156*160+ScreenStart
2343 5676 20 82                 DC W:157*160+ScreenStart
2344 5678 C0 82                 DC W:158*160+ScreenStart
2345 567A 60 83                 DC W:159*160+ScreenStart
2346 567C 00 84                 DC W:160*160+ScreenStart
2347 567E A0 84                 DC W:161*160+ScreenStart
2348 5680 40 85                 DC W:162*160+ScreenStart
2349 5682 E0 85                 DC W:163*160+ScreenStart
2350 5684 80 86                 DC W:164*160+ScreenStart
2351 5686 20 87                 DC W:165*160+ScreenStart
2352 5688 C0 87                 DC W:166*160+ScreenStart
2353 568A 60 88                 DC W:167*160+ScreenStart
2354 568C 00 89                 DC W:168*160+ScreenStart
2355 568E A0 89                 DC W:169*160+ScreenStart
2356 5690 40 8A                 DC W:170*160+ScreenStart
2357 5692 E0 8A                 DC W:171*160+ScreenStart
2358 5694 80 8B                 DC W:172*160+ScreenStart
2359 5696 20 8C                 DC W:173*160+ScreenStart
2360 5698 C0 8C                 DC W:174*160+ScreenStart
2361 569A 60 8D                 DC W:175*160+ScreenStart
2362 569C 00 8E                 DC W:176*160+ScreenStart
2363 569E A0 8E                 DC W:177*160+ScreenStart
2364 56A0 40 8F                 DC W:178*160+ScreenStart
2365 56A2 E0 8F                 DC W:179*160+ScreenStart
2366 56A4 80 90                 DC W:180*160+ScreenStart
2367 56A6 20 91                 DC W:181*160+ScreenStart  
2368 56A8 C0 91                 DC W:182*160+ScreenStart
2369 56AA 60 92                 DC W:183*160+ScreenStart
2370 56AC 00 93                 DC W:184*160+ScreenStart
2371 56AE A0 93                 DC W:185*160+ScreenStart
2372 56B0 40 94                 DC W:186*160+ScreenStart
2373 56B2 E0 94                 DC W:187*160+ScreenStart
2374 56B4 80 95                 DC W:188*160+ScreenStart
2375 56B6 20 96                 DC W:189*160+ScreenStart
2376 56B8 C0 96                 DC W:190*160+ScreenStart
2377 56BA 60 97                 DC W:191*160+ScreenStart
2378 56BC 00 98                 DC W:192*160+ScreenStart
2379 56BE A0 98                 DC W:193*160+ScreenStart
2380 56C0 40 99                 DC W:194*160+ScreenStart
2381 56C2 E0 99                 DC W:195*160+ScreenStart
2382 56C4 80 9A                 DC W:196*160+ScreenStart
2383 56C6 20 9B                 DC W:197*160+ScreenStart
2384 56C8 C0 9B                 DC W:198*160+ScreenStart
2385 56CA 60 9C                 DC W:199*160+ScreenStart
2386 56CC                       ENDP 
2387 56CC
2388 56CC
2389 56CC
2390 56CC                       END   
